/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.service;

import co.uk.automationconsultants.approvals.ao.Approval;
import co.uk.automationconsultants.approvals.ao.ApprovalMember;
import co.uk.automationconsultants.approvals.ao.settings.SpaceSettings;
import co.uk.automationconsultants.approvals.ao.settings.SystemStats;
import co.uk.automationconsultants.approvals.json.StatisticsJson;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

@Named(value="approvalMaintenanceService")
public class ApprovalMaintenanceService {
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final LocalNotificationService notificationService;
    @ComponentImport
    private final UserAccessor userAccessor;

    @Inject
    public ApprovalMaintenanceService(PageManager pageManager, ActiveObjects activeObjects, SpaceManager spaceManager, LocalNotificationService notificationService, UserAccessor userAccessor) {
        this.pageManager = pageManager;
        this.activeObjects = activeObjects;
        this.spaceManager = spaceManager;
        this.notificationService = notificationService;
        this.userAccessor = userAccessor;
    }

    public Boolean performCleanup() {
        this.removeInvalidSpaceEntities();
        this.removeInvalidPageEntities();
        this.removeSupersededEntites();
        return true;
    }

    public void removePageEntities(Long pageId) {
        Approval[] approvals;
        for (Approval approval : approvals = (Approval[])this.activeObjects.find(Approval.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}))) {
            this.removeNotifications(approval);
            this.activeObjects.delete((RawEntity[])approval.getMembers());
        }
        this.activeObjects.delete((RawEntity[])approvals);
    }

    public void removeSpaceEntities(Long spaceId) {
        SpaceSettings[] spaceSettings = (SpaceSettings[])this.activeObjects.find(SpaceSettings.class, Query.select().where("SPACE_ID = ?", new Object[]{spaceId}));
        this.activeObjects.delete((RawEntity[])spaceSettings);
    }

    private void removeInvalidPageEntities() {
        Arrays.stream((Approval[])this.activeObjects.find(Approval.class)).forEach(approval -> {
            Page page = this.pageManager.getPage(approval.getPageId());
            if (page == null) {
                this.removePageEntities(approval.getPageId());
            } else if (page.getContentStatusObject().equals((Object)ContentStatus.TRASHED)) {
                this.removePageEntities(approval.getPageId());
            }
        });
    }

    private void removeInvalidSpaceEntities() {
        List spaces = this.spaceManager.getAllSpaces().stream().map(EntityObject::getId).collect(Collectors.toList());
        for (Approval approval : (Approval[])this.activeObjects.find(Approval.class)) {
            if (spaces.contains(approval.getSpaceId())) continue;
            try {
                this.removeNotifications(approval);
                this.activeObjects.delete(new RawEntity[]{approval});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean saveSystemStats() {
        StatisticsJson statistics = this.getStatistics();
        this.activeObjects.create(SystemStats.class, new DBParam[]{new DBParam("DATE", (Object)new Date()), new DBParam("PENDING_COUNT", (Object)statistics.getCurrentPending()), new DBParam("APPROVED_COUNT", (Object)statistics.getCurrentApproved()), new DBParam("REJECTED_COUNT", (Object)statistics.getCurrentRejected()), new DBParam("EXPIRED_COUNT", (Object)statistics.getCurrentExpired()), new DBParam("TOTAL", (Object)statistics.total)});
        return true;
    }

    private void removeSupersededEntites() {
        for (Approval approval : (Approval[])this.activeObjects.find(Approval.class, Query.select().where("SUPERSEDED = ?", new Object[]{false}).order("ID DESC"))) {
            if (approval.getType().equals("macro")) {
                for (Approval outdatedApproval : (Approval[])this.activeObjects.find(Approval.class, Query.select().where("TYPE = ? AND PAGE_ID = ? AND UUID = ? AND ID < ?", new Object[]{"macro", approval.getPageId(), approval.getUuid(), approval.getID()}))) {
                    try {
                        outdatedApproval.setSuperseded(true);
                        outdatedApproval.save();
                        this.removeNotifications(outdatedApproval);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (!approval.getType().equals("page")) continue;
            for (Approval outdatedApproval : (Approval[])this.activeObjects.find(Approval.class, Query.select().where("TYPE = ? AND PAGE_ID = ? AND UUID IS NULL AND ID < ?", new Object[]{"page", approval.getPageId(), approval.getID()}))) {
                try {
                    outdatedApproval.setSuperseded(true);
                    outdatedApproval.save();
                    this.removeNotifications(outdatedApproval);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    void removeNotifications(Approval approval) {
        for (ApprovalMember member : approval.getMembers()) {
            ConfluenceUser user;
            if (member.getNotificationId() == null || (user = this.userAccessor.getUserByKey(new UserKey(member.getUserKey()))) == null) continue;
            this.notificationService.delete(user.getName(), member.getNotificationId().longValue());
        }
    }

    public StatisticsJson getStatistics() {
        int total = this.activeObjects.count(Approval.class);
        int totalPending = this.activeObjects.count(Approval.class, Query.select().where("STATUS = ?", new Object[]{"pending"}));
        int totalApproved = this.activeObjects.count(Approval.class, Query.select().where("STATUS = ?", new Object[]{"approved"}));
        int totalRejected = this.activeObjects.count(Approval.class, Query.select().where("STATUS = ?", new Object[]{"rejected"}));
        int totalExpired = this.activeObjects.count(Approval.class, Query.select().where("STATUS = ?", new Object[]{"expired"}));
        int current = this.activeObjects.count(Approval.class, Query.select().where("SUPERSEDED = ?", new Object[]{false}));
        int currentPending = this.activeObjects.count(Approval.class, Query.select().where("STATUS = ? AND SUPERSEDED = ?", new Object[]{"pending", false}));
        int currentApproved = this.activeObjects.count(Approval.class, Query.select().where("STATUS = ? AND SUPERSEDED = ?", new Object[]{"approved", false}));
        int currentRejected = this.activeObjects.count(Approval.class, Query.select().where("STATUS = ? AND SUPERSEDED = ?", new Object[]{"rejected", false}));
        int currentExpired = this.activeObjects.count(Approval.class, Query.select().where("STATUS = ? AND SUPERSEDED = ?", new Object[]{"expired", false}));
        return new StatisticsJson(total, totalPending, totalApproved, totalRejected, totalExpired, current, currentPending, currentApproved, currentRejected, currentExpired);
    }
}

