/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.macro;

import co.uk.automationconsultants.approvals.json.ApprovalJson;
import co.uk.automationconsultants.approvals.service.ApprovalService;
import co.uk.automationconsultants.approvals.service.exception.NoApprovalException;
import co.uk.automationconsultants.approvals.service.exception.NoPageException;
import co.uk.automationconsultants.approvals.service.exception.NoPagePermissionException;
import co.uk.automationconsultants.approvals.service.exception.NoPageVersionException;
import co.uk.automationconsultants.approvals.service.exception.NoSpacePermissionException;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class ApprovalMacro
implements Macro {
    private final ApprovalService approvalService;

    @Inject
    public ApprovalMacro(ApprovalService approvalService) {
        this.approvalService = approvalService;
    }

    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) {
        try {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            long pageId = this.getPageId(conversionContext);
            int pageVersion = this.getPageVersion(conversionContext);
            String macroId = this.getMacroId(conversionContext);
            String uuid = this.getUuid(map);
            int latestVersion = this.getLatestVersion(conversionContext);
            switch (conversionContext.getOutputType()) {
                case "display": {
                    return this.getReactRendered(user, pageId, pageVersion, macroId, uuid, latestVersion);
                }
                case "preview": {
                    return "<p>Preview</p>";
                }
            }
            return this.getServerRendered(user, pageId, pageVersion, macroId, uuid);
        }
        catch (Exception e) {
            map.put("error", e.getMessage());
            return VelocityUtils.getRenderedTemplate((String)"/templates/display/macro/error.vm", map);
        }
    }

    private int getLatestVersion(ConversionContext conversionContext) {
        ContentEntityObject entity = conversionContext.getEntity();
        if (entity != null) {
            return entity.getLatestVersion().getVersion();
        }
        return -1;
    }

    private String getServerRendered(ConfluenceUser user, long pageId, int pageVersion, String macroId, String uuid) throws NoPageException, NoSpacePermissionException, NoPagePermissionException, NoPageVersionException, NoApprovalException {
        ApprovalJson macroApproval = this.approvalService.getMacroApproval(user, pageId, uuid, macroId, pageVersion);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("creator", macroApproval.getCreatorUsername());
        parameters.put("title", macroApproval.getTitle());
        parameters.put("expireOnEdit", macroApproval.getExpireOnEdit());
        parameters.put("expiryDate", macroApproval.getExpiryDate());
        parameters.put("quorumSize", macroApproval.getQuorumSize());
        parameters.put("members", macroApproval.getMembers());
        parameters.put("version", macroApproval.getVersion());
        parameters.put("superseded", macroApproval.getSuperseded());
        return VelocityUtils.getRenderedTemplate((String)"/templates/display/macro/server.vm", parameters);
    }

    private String getReactRendered(ConfluenceUser user, long pageId, int pageVersion, String macroId, String uuid, int latestVersion) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("pageId", pageId);
        parameters.put("pageVersion", pageVersion);
        parameters.put("macroId", macroId);
        parameters.put("macroUuid", uuid);
        parameters.put("latestVersion", latestVersion);
        return VelocityUtils.getRenderedTemplate((String)"/templates/display/macro/react.vm", parameters);
    }

    private long getPageId(ConversionContext context) throws NullPointerException {
        return Objects.requireNonNull(context.getEntity()).getLatestVersionId();
    }

    private int getPageVersion(ConversionContext context) throws NullPointerException {
        return Objects.requireNonNull(context.getEntity()).getVersion();
    }

    private String getMacroId(ConversionContext context) throws NullPointerException {
        MacroDefinition macroDefinition = (MacroDefinition)context.getProperty("macroDefinition");
        return ((MacroId)macroDefinition.getMacroId().getOrThrow(() -> new NullPointerException("No Macro ID Found"))).getId();
    }

    private String getUuid(Map<String, String> map) {
        String uuid = map.get("uuid");
        if (uuid != null) {
            return uuid;
        }
        throw new NullPointerException("This Approval Macro hasn't been set up yet.");
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

