/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.json.search;

import co.uk.automationconsultants.approvals.ao.Approval;
import co.uk.automationconsultants.approvals.json.ApprovalMemberJson;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ApprovalSearchResultJson {
    @XmlElement(name="type")
    public String type;
    @XmlElement(name="title")
    public String title;
    @XmlElement(name="spaceKey")
    public String spaceKey;
    @XmlElement(name="status")
    public String status;
    @XmlElement(name="createdOn")
    public Date createdOn;
    @XmlElement(name="updatedOn")
    public Date updatedOn;
    @XmlElement(name="creator")
    public String creator;
    @XmlElement(name="creatorDisplayName")
    public String creatorDisplayName;
    @XmlElement(name="creatorProfilePicture")
    public String creatorProfilePicture;
    @XmlElement(name="updator")
    public String updator;
    @XmlElement(name="updatorDisplayName")
    public String updatorDisplayName;
    @XmlElement(name="updatorProfilePicture")
    public String updatorProfilePicture;
    @XmlElement(name="members")
    public List<ApprovalMemberJson> members;
    @XmlElement(name="pageId")
    public long pageId;
    @XmlElement(name="pageTitle")
    public String pageTitle;
    @XmlElement(name="pageVersion")
    public int pageVersion;
    @XmlElement(name="creatorUsername")
    public String creatorUsername;
    @XmlElement(name="updatorUsername")
    public String updatorUsername;
    @XmlElement(name="expiryDate")
    public Date expiryDate;

    public static ApprovalSearchResultJson map(Approval approval, UserAccessor userAccessor, PageManager pageManager) {
        ConfluenceUser creator = userAccessor.getUserByKey(new UserKey(approval.getCreator()));
        ConfluenceUser updator = userAccessor.getUserByKey(new UserKey(approval.getUpdator()));
        Page page = pageManager.getPage(approval.getPageId());
        String pageTitle = page == null ? "Unknown" : page.getTitle();
        int pageVersion = page == null ? 0 : page.getVersion();
        String spaceKey = page == null ? "?" : page.getSpaceKey();
        return new ApprovalSearchResultJson(approval.getType(), approval.getTitle(), approval.getStatus(), approval.getCreationDate(), approval.getUpdateDate(), approval.getCreator(), approval.getUpdator(), ApprovalMemberJson.mapAll(userAccessor, approval.getMembers()), approval.getPageId(), pageTitle, pageVersion, spaceKey, creator == null ? "Unknown" : creator.getFullName(), creator == null ? "" : userAccessor.getUserProfilePicture((User)creator).getUriReference(), updator == null ? "Unknown" : updator.getFullName(), updator == null ? "" : userAccessor.getUserProfilePicture((User)updator).getUriReference(), creator == null ? "Unknown" : creator.getName(), updator == null ? "Unknown" : updator.getName(), approval.getExpiryDate());
    }

    public static Stream<ApprovalSearchResultJson> mapAll(PageManager pageManager, UserAccessor userAccessor, Stream<Approval> approvals) {
        return approvals.map(approval -> ApprovalSearchResultJson.map(approval, userAccessor, pageManager));
    }

    public ApprovalSearchResultJson() {
    }

    public ApprovalSearchResultJson(String type, String title, String status, Date createdOn, Date updatedOn, String creator, String updator, List<ApprovalMemberJson> members, long pageId, String pageTitle, int pageVersion, String spaceKey, String creatorDisplayName, String creatorProfilePicture, String updatorDisplayName, String updatorProfilePicture, String updatorUsername, String creatorUsername, Date expiryDate) {
        this.type = type;
        this.title = title;
        this.status = status;
        this.createdOn = createdOn;
        this.updatedOn = updatedOn;
        this.creator = creator;
        this.updator = updator;
        this.members = members;
        this.pageId = pageId;
        this.pageTitle = pageTitle;
        this.pageVersion = pageVersion;
        this.spaceKey = spaceKey;
        this.creatorDisplayName = creatorDisplayName;
        this.creatorProfilePicture = creatorProfilePicture;
        this.updatorDisplayName = updatorDisplayName;
        this.updatorProfilePicture = updatorProfilePicture;
        this.creatorUsername = creatorUsername;
        this.updatorUsername = updatorUsername;
        this.expiryDate = expiryDate;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getUpdatedOn() {
        return this.updatedOn;
    }

    public void setUpdatedOn(Date updatedOn) {
        this.updatedOn = updatedOn;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getUpdator() {
        return this.updator;
    }

    public void setUpdator(String updator) {
        this.updator = updator;
    }

    public List<ApprovalMemberJson> getMembers() {
        return this.members;
    }

    public void setMembers(List<ApprovalMemberJson> members) {
        this.members = members;
    }

    public long getPageId() {
        return this.pageId;
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public int getPageVersion() {
        return this.pageVersion;
    }

    public void setPageVersion(int pageVersion) {
        this.pageVersion = pageVersion;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getCreatorDisplayName() {
        return this.creatorDisplayName;
    }

    public void setCreatorDisplayName(String creatorDisplayName) {
        this.creatorDisplayName = creatorDisplayName;
    }

    public String getCreatorProfilePicture() {
        return this.creatorProfilePicture;
    }

    public void setCreatorProfilePicture(String creatorProfilePicture) {
        this.creatorProfilePicture = creatorProfilePicture;
    }

    public String getUpdatorDisplayName() {
        return this.updatorDisplayName;
    }

    public void setUpdatorDisplayName(String updatorDisplayName) {
        this.updatorDisplayName = updatorDisplayName;
    }

    public String getUpdatorProfilePicture() {
        return this.updatorProfilePicture;
    }

    public void setUpdatorProfilePicture(String updatorProfilePicture) {
        this.updatorProfilePicture = updatorProfilePicture;
    }
}

