/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.service;

import co.uk.automationconsultants.approvals.ao.Approval;
import co.uk.automationconsultants.approvals.cache.SpaceSettingsCache;
import co.uk.automationconsultants.approvals.json.ApprovalJson;
import co.uk.automationconsultants.approvals.json.settings.SystemSettingsJson;
import co.uk.automationconsultants.approvals.service.ApprovalSystemService;
import co.uk.automationconsultants.approvals.service.enumerator.ApproverType;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.mail.notification.NotificationsSender;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringEscapeUtils;

@Named(value="approvalEmailService")
public class ApprovalEmailService {
    @ComponentImport
    private final NotificationsSender notificationsSender;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final SettingsManager settingsManager;
    private final ApprovalSystemService approvalSystemService;
    private final SpaceSettingsCache spaceSettingsCache;

    @Inject
    public ApprovalEmailService(NotificationsSender notificationsSender, UserAccessor userAccessor, PageManager pageManager, SettingsManager settingsManager, ApprovalSystemService approvalSystemService, SpaceSettingsCache spaceSettingsCache) {
        this.notificationsSender = notificationsSender;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        this.settingsManager = settingsManager;
        this.approvalSystemService = approvalSystemService;
        this.spaceSettingsCache = spaceSettingsCache;
    }

    public void sendApprovalRequestEmails(Map<String, ApproverType> map, Approval approval) {
        SystemSettingsJson settings = this.approvalSystemService.getSettings();
        if (this.isApprovalsEnabled(settings, approval.getSpaceId()) && settings.getNotificationsEmail().booleanValue() && approval.isRequestNotificationEnabled().booleanValue()) {
            String updatorUserKey = approval.getUpdator();
            ConfluenceUser updator = this.userAccessor.getUserByKey(new UserKey(updatorUserKey));
            long pageId = approval.getPageId();
            Page page = this.pageManager.getPage(pageId);
            if (updator != null && page != null) {
                for (String recipientUserKey : map.keySet()) {
                    ConfluenceUser recipient = this.userAccessor.getUserByKey(new UserKey(recipientUserKey));
                    if (recipient == null) continue;
                    String subject = (map.get(recipientUserKey) == ApproverType.APPROVAL ? "Approval Requested" : "Approval Expired").concat(" on " + approval.getTitle());
                    String template = map.get(recipientUserKey) == ApproverType.APPROVAL ? "approval.vm" : "reapproval.vm";
                    NotificationData data = new NotificationData((User)updator, false, (ConfluenceEntityObject)page, subject, template, null);
                    NotificationContext context = data.cloneContext();
                    context.put("baseUrl", (Object)this.settingsManager.getGlobalSettings().getBaseUrl());
                    context.put("mailRecipient", (Object)recipient.getFullName());
                    context.put("pageId", (Object)pageId);
                    context.put("approvalTitle", (Object)approval.getTitle());
                    context.put("pageTitle", (Object)page.getDisplayTitle());
                    context.put("updatorUsername", (Object)updator.getName());
                    context.put("updatorFullName", (Object)updator.getFullName());
                    context.put("subject", (Object)subject);
                    this.notificationsSender.sendNotification(recipient.getName(), context, data, null);
                }
            }
        }
    }

    public void sendApprovalStatusEmails(Approval approval) {
        SystemSettingsJson settings = this.approvalSystemService.getSettings();
        if (this.isApprovalsEnabled(settings, approval.getSpaceId()) && Boolean.TRUE.equals(settings.getNotificationsEmail())) {
            String updatorUserKey = approval.getUpdator();
            ConfluenceUser updator = this.userAccessor.getUserByKey(new UserKey(updatorUserKey));
            long pageId = approval.getPageId();
            Page page = this.pageManager.getPage(pageId);
            if (updator != null && page != null) {
                String subject;
                ApprovalJson approvalJson = ApprovalJson.map(this.userAccessor, approval);
                switch (approvalJson.getStatus()) {
                    case "pending": {
                        subject = "Approval Update: " + approval.getTitle() + " (" + settings.getPendingText() + ")";
                        break;
                    }
                    case "approved": {
                        subject = "Approval Update: " + approval.getTitle() + " (" + settings.getApprovedText() + ")";
                        break;
                    }
                    case "rejected": {
                        subject = "Approval Update: " + approval.getTitle() + " (" + settings.getRejectedText() + ")";
                        break;
                    }
                    case "expired": {
                        subject = "Approval Update: " + approval.getTitle() + " (" + settings.getExpiredText() + ")";
                        break;
                    }
                    default: {
                        subject = "Approval Status Update";
                    }
                }
                NotificationData data = new NotificationData((User)updator, true, (ConfluenceEntityObject)page, subject, "status.vm", null);
                NotificationContext context = data.cloneContext();
                context.put("baseUrl", (Object)this.settingsManager.getGlobalSettings().getBaseUrl());
                context.put("mailRecipient", (Object)updator.getFullName());
                context.put("pageId", (Object)pageId);
                context.put("approvalTitle", (Object)approval.getTitle());
                context.put("subject", (Object)StringEscapeUtils.escapeHtml((String)subject));
                context.put("pageTitle", (Object)StringEscapeUtils.escapeHtml((String)page.getDisplayTitle()));
                context.put("updatorUsername", (Object)updator.getName());
                context.put("updatorFullName", (Object)updator.getFullName());
                context.put("members", approvalJson.getMembers());
                this.notificationsSender.sendNotification(updator.getName(), context, data, null);
            }
        }
    }

    private boolean isApprovalsEnabled(SystemSettingsJson settings, long spaceId) {
        if (Boolean.TRUE.equals(settings.getGloballyControlled())) {
            return settings.getEnabled();
        }
        return this.spaceSettingsCache.getSpaceSettings(spaceId).isEnabled();
    }
}

