AJS.bind("init.rte", function() {
    var macroName = 'approval';
    // Create Dialog HTML
    AJS.$("body").append("<section id=\"approval-macro-editor\" class=\"aui-dialog2 aui-dialog2-medium aui-layer\" role=\"dialog\" aria-hidden=\"true\">\n" +
        "    <header class=\"aui-dialog2-header\">\n" +
        "        <h2 class=\"aui-dialog2-header-main\">Approval</h2>\n" +
        "        <a class=\"aui-dialog2-header-close\">\n" +
        "            <span id=\"dialog-close\" class=\"aui-icon aui-icon-small aui-iconfont-close-dialog\">Close</span>\n" +
        "        </a>\n" +
        "    </header>\n" +
        "    <div class=\"aui-dialog2-content\">\n" +
        "        <div id=\"approvalsForConfluenceMacroEditRoot\"></div>\n" +
        "    </div>\n" +
        "</section>");

    AJS.MacroBrowser.setMacroJsOverride(macroName, {
        opener: function (macro) {
            // Generate UUID
            approvalsForConfluence.renderMacroEdit("approvalsForConfluenceMacroEditRoot", macro, function (data) {
                var selection = AJS.Rte.getEditor().selection.getNode();
                var macro = {
                    name: macroName,
                    params: {
                        title: data.title,
                        expireOnEdit: data.expireOnEdit,
                        expireOnDate: data.expireOnDate,
                        expiryDate: data.expiryDate,
                        enableQuorum: data.quorumSize > 0,
                        quorumSize: data.quorumSize,
                        statusNotifications: data.statusNotifications,
                        requestNotifications: data.requestNotifications,
                        approvers: JSON.stringify(data.approvers),
                        count: data.approvers.length + (data.approvers.length === 1 ? " Approver" : " Approvers"),
                        uuid: data.uuid
                    }
                };
                tinymce.confluence.macrobrowser.macroBrowserComplete(macro);
                AJS.dialog2("#approval-macro-editor").hide();
            }, typeof macro.params === "undefined" ? null : macro.params.uuid);
            AJS.dialog2("#approval-macro-editor").show();
        }
    });

    AJS.$("#dialog-close").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#approval-macro-editor").hide();
    });
});