/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.service.migration;

import co.uk.automationconsultants.approvals.ao.Approval;
import co.uk.automationconsultants.approvals.ao.ApprovalMember;
import co.uk.automationconsultants.approvals.helper.GroupHelper;
import co.uk.automationconsultants.approvals.json.ApprovalJson;
import co.uk.automationconsultants.approvals.json.ApprovalMemberJson;
import co.uk.automationconsultants.approvals.service.ApprovalService;
import co.uk.automationconsultants.approvals.service.migration.SpaceMacroMigrationService;
import co.uk.automationconsultants.approvals.utils.ApprovalMigrationUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.MacroUsageQuery;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Named(value="approvalMigrationService")
public class ApprovalMigrationService {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final ContentPropertyManager contentPropertyManager;
    @ComponentImport
    private final SearchManager searchManager;
    private final ApprovalService approvalService;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final SpaceMacroMigrationService spaceMacroMigrationService;
    private final GroupHelper groupHelper;
    private static final Logger logger = LoggerFactory.getLogger(ApprovalMigrationService.class);

    @Inject
    public ApprovalMigrationService(ActiveObjects activeObjects, PageManager pageManager, ContentPropertyManager contentPropertyManager, SearchManager searchManager, ApprovalService approvalService, UserAccessor userAccessor, SpaceMacroMigrationService spaceMacroMigrationService, GroupHelper groupHelper) {
        this.activeObjects = activeObjects;
        this.pageManager = pageManager;
        this.contentPropertyManager = contentPropertyManager;
        this.searchManager = searchManager;
        this.approvalService = approvalService;
        this.userAccessor = userAccessor;
        this.spaceMacroMigrationService = spaceMacroMigrationService;
        this.groupHelper = groupHelper;
    }

    public int migrateFromServiceRocket(ConfluenceUser currentUser, boolean deleteOldApprovals) {
        logger.info("Starting Service Rocket Migration");
        int total = 0;
        try {
            ISearch search = this.generateFindPagesWithMacroQuery();
            logger.info("Detected {} pages for migration", (Object)this.searchManager.search(search).getUnfilteredResultsCount());
            while (search != null) {
                SearchResults searchResults = this.searchManager.search(search);
                total += this.migratePages(searchResults, currentUser, deleteOldApprovals);
                search = searchResults.getNextPageSearch();
            }
        }
        catch (InvalidSearchException e) {
            logger.error("An error occurred while migrating pages from Service Rocket. Invalid Search", (Throwable)e);
        }
        catch (ReflectiveOperationException e) {
            logger.error("An error occurred while instantiating the ContentSearch class, a valid constructor was not found", (Throwable)e);
        }
        logger.info("Completed Service Rocket Migration. {} approvals were migrated", (Object)total);
        return total;
    }

    private ISearch generateFindPagesWithMacroQuery() throws ReflectiveOperationException {
        MacroUsageQuery query = new MacroUsageQuery("pageapproval");
        return this.initContentSearch((SearchQuery)query);
    }

    private int migratePages(SearchResults searchResults, ConfluenceUser currentUser, boolean deleteOldApprovals) {
        List all = searchResults.getAll();
        int total = 0;
        for (SearchResult searchResult : all) {
            try {
                long pageId = Long.parseLong(searchResult.getField("handle").split("Page-")[1]);
                Page page = this.pageManager.getPage(pageId);
                if (deleteOldApprovals) {
                    this.deletePageApprovals(pageId);
                }
                if (page == null) continue;
                logger.info("Migrating Page '{}' to Approvals for Confluence", (Object)page.getTitle());
                ApprovalJson approvalJson = this.processPage((AbstractPage)page, currentUser);
                logger.info("Begin migrating old versions of Page '{}' to Approvals for Confluence", (Object)page.getTitle());
                for (int version = 1; version < page.getVersion(); ++version) {
                    AbstractPage historicPage = this.pageManager.getPageByVersion((AbstractPage)page, version);
                    if (historicPage == null) continue;
                    logger.info("Migrate page '{}' version {} to approvals for Confluence", (Object)page.getTitle(), (Object)page.getVersion());
                    ApprovalJson historicJson = this.processPage(historicPage, currentUser);
                    if (historicJson == null) continue;
                    ++total;
                    this.createPageApprovalEntity(historicJson, (AbstractPage)page);
                }
                if (approvalJson != null) {
                    ++total;
                    this.createPageApprovalEntity(approvalJson, (AbstractPage)page);
                }
                logger.info("End migration for Page '{}'", (Object)page.getTitle());
            }
            catch (Exception e) {
                logger.error("An error occurred while migrating pages from Service Rocket", (Throwable)e);
            }
        }
        return total;
    }

    private void createPageApprovalEntity(ApprovalJson approvalJson, AbstractPage page) {
        try {
            this.approvalService.markSupersededPageApprovals(page.getId(), page.getVersion());
            String user = approvalJson.getCreatorUsername();
            this.activeObjects.executeInTransaction(() -> {
                Approval approvalRet = (Approval)this.activeObjects.create(Approval.class, new DBParam[]{new DBParam("TYPE", (Object)"page"), new DBParam("STATUS", (Object)approvalJson.getStatus()), new DBParam("TITLE", (Object)approvalJson.getTitle()), new DBParam("MACRO_ID", null), new DBParam("PAGE_ID", (Object)approvalJson.getPageId()), new DBParam("EXPIRE_ON_EDIT", (Object)approvalJson.getExpireOnEdit()), new DBParam("EXPIRY_DATE", (Object)approvalJson.getExpiryDate()), new DBParam("QUORUM_SIZE", (Object)approvalJson.getQuorumSize()), new DBParam("POST_COMMENTS_ENABLED", (Object)false), new DBParam("CREATION_DATE", (Object)approvalJson.getCreated()), new DBParam("UPDATE_DATE", (Object)approvalJson.getUpdated()), new DBParam("CREATOR", (Object)user), new DBParam("UPDATOR", (Object)user), new DBParam("VERSION", (Object)approvalJson.getVersion()), new DBParam("STATUS_NOTIFICATION_ENABLED", (Object)true), new DBParam("REQUEST_NOTIFICATION_ENABLED", (Object)true), new DBParam("UUID", null), new DBParam("SUPERSEDED", (Object)approvalJson.getSuperseded()), new DBParam("SPACE_ID", (Object)page.getSpace().getId())});
                return this.createMembers(approvalJson.getMembers(), approvalRet);
            });
        }
        catch (Exception e) {
            logger.error("An error occurred when adding approval during service rocket migration ", (Throwable)e);
        }
    }

    private void deletePageApprovals(long pageId) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                Approval[] approvals = (Approval[])this.activeObjects.find(Approval.class, Query.select().where("PAGE_ID = ? AND TYPE = ?", new Object[]{pageId, "page"}));
                Arrays.stream(approvals).forEach(approval -> this.activeObjects.delete((RawEntity[])approval.getMembers()));
                this.activeObjects.delete((RawEntity[])approvals);
                logger.info("Deleted old approvals for page {}", (Object)pageId);
                return null;
            });
        }
        catch (Exception e) {
            logger.error("Failed to delete old page approvals for page {}", (Object)pageId, (Object)e);
        }
    }

    private Approval createMembers(List<ApprovalMemberJson> members, Approval approval) {
        for (ApprovalMemberJson member : members) {
            this.activeObjects.create(ApprovalMember.class, new DBParam[]{new DBParam("APPROVAL_ID", (Object)approval.getID()), new DBParam("USER_KEY", (Object)member.getUserKey()), new DBParam("DATE", (Object)member.getDate()), new DBParam("STATUS", (Object)member.getStatus()), new DBParam("COMMENT", (Object)member.getComment())});
        }
        return approval;
    }

    private Document getDomElement(String xml) {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            doc = db.parse(is);
        }
        catch (IOException | ParserConfigurationException e) {
            return null;
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return doc;
    }

    private ApprovalJson getDefaultJson(AbstractPage page, ConfluenceUser currentUser) {
        return new ApprovalJson("page", page.getLastModifier() != null ? page.getLastModifier().getKey().getStringValue() : currentUser.getKey().getStringValue(), page.getLatestVersion().getId(), null, page.getDisplayTitle(), true, true, true, null, 0, false, new ArrayList<ApprovalMemberJson>(), page.getVersion(), null, !page.isCurrent(), "pending", page.getSpace() != null ? Long.valueOf(page.getSpace().getId()) : null, page.getCreationDate(), page.getLastModificationDate());
    }

    private ApprovalMemberJson getMemberJson(ConfluenceUser user, AbstractPage page) {
        if (user != null) {
            ApprovalMemberJson member = new ApprovalMemberJson(null, user.getKey().getStringValue(), "pending", null, null, null, null);
            String comment = this.contentPropertyManager.getStringProperty((ContentEntityObject)page, "com.saikore.pageapprovalcomment&" + user.getName() + "&" + page.getVersion());
            member.setComment(comment);
            String approvedBy = this.contentPropertyManager.getStringProperty((ContentEntityObject)page.getLatestVersion(), "com.saikore.pageapprovalcom.saikore.pageapprovalapprovedby" + page.getVersion());
            if (approvedBy != null) {
                for (String s : approvedBy.split("\\?")) {
                    if (!s.equals(user.getName())) continue;
                    member.setStatus("approved");
                    String date = this.contentPropertyManager.getStringProperty((ContentEntityObject)page, "com.saikore.pageapprovalapprovaldate&" + user.getName() + "&" + page.getVersion());
                    if (date == null) continue;
                    SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                    try {
                        member.setDate(dateFormat.parse(date));
                    }
                    catch (ParseException e) {
                        member.setDate(page.getLastModificationDate());
                    }
                }
            }
            return member;
        }
        return null;
    }

    private Date getDateForRelativeExpiry(String status, List<ApprovalMemberJson> members) {
        if (status.equals("approved")) {
            return members.stream().map(ApprovalMemberJson::getDate).max(Comparator.comparingLong(Date::getTime)).orElse(null);
        }
        return null;
    }

    private ApprovalJson processMacro(Node macroNode, AbstractPage page, ConfluenceUser currentUser) {
        String status;
        ApprovalJson approvalJson = this.getDefaultJson(page, currentUser);
        List<ApprovalMemberJson> members = this.getApprovalMembers(macroNode, page);
        approvalJson.setMembers(members);
        String quorumSize = this.contentPropertyManager.getStringProperty((ContentEntityObject)page, "com.saikore.pageapprovalquorum");
        if (quorumSize != null) {
            try {
                Integer quorum = Integer.valueOf(quorumSize);
                approvalJson.setQuorumSize(quorum);
            }
            catch (NumberFormatException e) {
                approvalJson.setQuorumSize(0);
            }
        }
        if (Boolean.parseBoolean(status = this.contentPropertyManager.getStringProperty((ContentEntityObject)page.getLatestVersion(), "com.saikore.pageapprovalapprovalstate?" + page.getVersion()))) {
            approvalJson.setStatus("approved");
        } else {
            approvalJson.setStatus("pending");
        }
        Date dateForRelativeExpiry = this.getDateForRelativeExpiry(approvalJson.getStatus(), approvalJson.getMembers());
        approvalJson.setExpiryDate(this.getExpiryDate(dateForRelativeExpiry, macroNode, page.getSpaceKey()));
        if (!approvalJson.getMembers().isEmpty()) {
            return approvalJson;
        }
        return null;
    }

    private Date getExpiryDate(Date dateForRelativeExpiry, Node macroNode, String spaceKey) {
        Integer month = null;
        Integer day = null;
        Date date = null;
        NodeList children = macroNode.getChildNodes();
        block10: for (int j = 0; j < children.getLength(); ++j) {
            String parameter;
            switch (parameter = children.item(j).getAttributes().getNamedItem("ac:name").getNodeValue()) {
                case "expirymonth": {
                    month = Integer.valueOf(children.item(j).getFirstChild().getTextContent());
                    continue block10;
                }
                case "expiryday": {
                    day = Integer.valueOf(children.item(j).getFirstChild().getTextContent());
                    continue block10;
                }
                case "expireafter": {
                    String timePeriod = String.valueOf(children.item(j).getFirstChild().getTextContent());
                    date = ApprovalMigrationUtils.parseExpireAfterTerm(dateForRelativeExpiry, timePeriod);
                    continue block10;
                }
            }
        }
        if (month == null && day == null && date == null && this.spaceMacroMigrationService.isSpaceSettingsEnabled(spaceKey)) {
            return this.spaceMacroMigrationService.getExpiryDate(dateForRelativeExpiry, spaceKey);
        }
        if (month != null || day != null) {
            return ApprovalMigrationUtils.parseExpiryDate(new Date(), month, day);
        }
        if (date != null) {
            return date;
        }
        return ApprovalMigrationUtils.parseExpiryDate(new Date(), month, day);
    }

    private List<ConfluenceUser> getUsers(Node macroNode, AbstractPage page) {
        HashSet<ConfluenceUser> allUsers = new HashSet<ConfluenceUser>();
        boolean isSpaceMacro = false;
        NodeList children = macroNode.getChildNodes();
        block12: for (int j = 0; j < children.getLength(); ++j) {
            String[] parameter;
            switch (parameter = children.item(j).getAttributes().getNamedItem("ac:name").getNodeValue()) {
                case "users": {
                    NodeList users = children.item(j).getChildNodes();
                    for (int k = 0; k < users.getLength(); ++k) {
                        if (allUsers.size() >= 20) {
                            return new ArrayList<ConfluenceUser>(allUsers);
                        }
                        String userValue = users.item(k).getAttributes().getNamedItem("ri:userkey").getNodeValue();
                        ConfluenceUser userObject = this.userAccessor.getUserByKey(new UserKey(userValue));
                        allUsers.add(userObject);
                    }
                    continue block12;
                }
                case "approvalGroup": {
                    String groupNames = children.item(j).getFirstChild().getTextContent();
                    for (String groupName : groupNames.split(",")) {
                        if (allUsers.size() >= 20) {
                            return new ArrayList<ConfluenceUser>(allUsers);
                        }
                        List<ConfluenceUser> groupUsers = this.groupHelper.getGroupMembers(groupName, 20);
                        this.mergeMembers(allUsers, new HashSet<ConfluenceUser>(groupUsers));
                    }
                    continue block12;
                }
                case "spacemacro": {
                    isSpaceMacro = Boolean.parseBoolean(children.item(j).getFirstChild().getTextContent());
                    continue block12;
                }
            }
        }
        if (isSpaceMacro || this.spaceMacroMigrationService.isSpaceSettingsEnabled(page.getSpaceKey())) {
            Set<ConfluenceUser> spaceUsers = this.spaceMacroMigrationService.getUsers(page.getSpaceKey());
            this.mergeMembers(allUsers, spaceUsers);
        }
        try {
            String[] allApprovalUsers;
            for (String approvalUser : allApprovalUsers = this.contentPropertyManager.getStringProperty((ContentEntityObject)page.getLatestVersion(), "com.saikore.pageapprovalcom.saikore.pageapprovalmyUsers1").split("\\?")) {
                if (allUsers.contains(this.userAccessor.getUserByName(approvalUser))) continue;
                allUsers.add(this.userAccessor.getUserByName(approvalUser));
            }
        }
        catch (NullPointerException e) {
            logger.error("An error occurred while migrating pages from Service Rocket. Invalid Search", (Throwable)e);
        }
        String deregisteredUsersProperty = this.contentPropertyManager.getStringProperty((ContentEntityObject)page.getLatestVersion(), "com.saikore.pageapprovalcom.saikore.pageapprovalisnotactive" + page.getVersion());
        if (deregisteredUsersProperty != null) {
            Set deregisteredUsernames = Arrays.stream(deregisteredUsersProperty.split("\\?")).collect(Collectors.toSet());
            return allUsers.stream().filter(user -> !deregisteredUsernames.contains(user.getName())).collect(Collectors.toList());
        }
        return new ArrayList<ConfluenceUser>(allUsers);
    }

    private List<ApprovalMemberJson> getApprovalMembersFromUsers(List<ConfluenceUser> users, AbstractPage page) {
        return users.stream().map(user -> this.getMemberJson((ConfluenceUser)user, page)).collect(Collectors.toList());
    }

    private <T> void mergeMembers(Set<T> members, Set<T> partialMembers) {
        int extraMembersAllowed = 20 - members.size();
        List<T> additionalMembers = new ArrayList<T>(partialMembers).subList(0, Math.min(extraMembersAllowed, partialMembers.size()));
        members.addAll(additionalMembers);
    }

    private List<ApprovalMemberJson> getApprovalMembers(Node macroNode, AbstractPage page) {
        List<ConfluenceUser> users = this.getUsers(macroNode, page);
        return this.getApprovalMembersFromUsers(users, page);
    }

    private ApprovalJson processPage(AbstractPage page, ConfluenceUser currentUser) {
        Document document = this.getDomElement("<p>" + page.getBodyAsString().replace("&", "&#038;") + "</p>");
        if (document != null) {
            NodeList macros = document.getElementsByTagName("ac:structured-macro");
            for (int i = 0; i < macros.getLength(); ++i) {
                NamedNodeMap attributes;
                Node item = macros.item(i);
                if (!"pageapproval".equals(item.getAttributes().getNamedItem("ac:name").getNodeValue()) || (attributes = item.getAttributes()).getNamedItem("ac:macro-id").getNodeValue() == null || attributes.getNamedItem("ac:macro-id").getNodeValue().length() <= 0) continue;
                return this.processMacro(item, page, currentUser);
            }
            NodeList possSpaceMacros = document.getElementsByTagName("ac:macro");
            for (int i = 0; i < possSpaceMacros.getLength(); ++i) {
                Node item = possSpaceMacros.item(i);
                if (!"pageapproval".equals(item.getAttributes().getNamedItem("ac:name").getNodeValue())) continue;
                return this.processMacro(item, page, currentUser);
            }
        }
        return null;
    }

    private ContentSearch initContentSearch(SearchQuery query) throws ReflectiveOperationException {
        try {
            Constructor ctr = ContentSearch.class.getConstructor(SearchQuery.class, SearchSort.class, Integer.TYPE, Integer.TYPE);
            return (ContentSearch)ctr.newInstance(query, null, 0, 500);
        }
        catch (NoSuchMethodException e) {
            logger.debug("New ContentSearch constructor not found, falling back to old constructor...");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.debug("Found new ContentSearch constructor, but could not instantiate with it");
        }
        try {
            Constructor<?>[] ctrs;
            for (Constructor<?> ctr : ctrs = ContentSearch.class.getConstructors()) {
                if (ctr.getGenericParameterTypes().length != 5) continue;
                return (ContentSearch)ctr.newInstance(query, null, null, 0, 500);
            }
            logger.debug("Could not find old ContentSearch constructor with desired signature");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.debug("Found old ContentSearch constructor, but could not instantiate with it");
        }
        logger.debug("Attempt to re-instantiate new constructor, if it fails throw a ReflectiveOperationException");
        Constructor ctr = ContentSearch.class.getConstructor(SearchQuery.class, SearchSort.class, Integer.TYPE, Integer.TYPE);
        return (ContentSearch)ctr.newInstance(query, null, 0, 500);
    }
}

