/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.rest;

import co.uk.automationconsultants.approvals.json.request.SearchRequest;
import co.uk.automationconsultants.approvals.json.search.ApprovalSearchResultJson;
import co.uk.automationconsultants.approvals.service.ApprovalSearchService;
import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/search")
@PublicApi
public class SearchRest {
    private final ApprovalSearchService approvalSearchService;

    @Inject
    public SearchRest(ApprovalSearchService approvalSearchService) {
        this.approvalSearchService = approvalSearchService;
    }

    @POST
    @Path(value="/meta")
    @Produces(value={"application/json"})
    @PublicApi
    public Response searchCreatorUpdators(@Context HttpServletRequest request, SearchRequest searchRequest) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            Stream<ApprovalSearchResultJson> approvals = this.approvalSearchService.searchApprovalCreatorUpdator(user, searchRequest.getUserKey(), searchRequest.getStatus(), searchRequest.getSpace());
            return Response.ok(approvals.collect(Collectors.toList())).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @POST
    @Produces(value={"application/json"})
    @PublicApi
    public Response searchMembers(@Context HttpServletRequest request, SearchRequest searchRequest) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            Stream<ApprovalSearchResultJson> approvals = this.approvalSearchService.searchApprovalMembers(user, searchRequest.getUserKey(), searchRequest.getStatus(), searchRequest.getSpace());
            return Response.ok(approvals.collect(Collectors.toList())).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }
}

