/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.rest;

import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.userstatus.FavouriteManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import com.atsistemas.confluence.app.awesomemacros.component.vo.SpaceVO;
import com.google.gson.Gson;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/space")
@Scanned
public class Spaces {
    private static final Logger log = LoggerFactory.getLogger(Spaces.class);
    @ConfluenceImport
    private SpacePermissionManager spacePermissionManager;
    @ConfluenceImport
    private FavouriteManager favouriteManager;
    @ConfluenceImport
    private SpaceManager spaceManager;

    @Autowired
    public Spaces(SpacePermissionManager spacePermissionManager, FavouriteManager favouriteManager, SpaceManager spaceManager) {
        this.spacePermissionManager = spacePermissionManager;
        this.favouriteManager = favouriteManager;
        this.spaceManager = spaceManager;
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @Path(value="/favourite")
    public Response makeFavourite(SpaceVO spaceVo) {
        try {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            Space space = this.spaceManager.getSpace(spaceVo.getKey());
            if (space != null && user != null && this.spacePermissionManager.hasPermission("VIEWSPACE", space, (User)user)) {
                this.favouriteManager.addSpaceToFavourites((User)user, space);
                return Response.ok().build();
            }
            log.warn("Cannot make space favourite: Permissions or space doesn't exist");
            return Response.notModified().build();
        }
        catch (Exception e) {
            log.error("Cannot make space favourite", (Throwable)e);
            return Response.serverError().entity((Object)new Gson().toJson(e.getMessage())).build();
        }
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @DELETE
    @Path(value="/favourite")
    public Response deleteFavourite(@QueryParam(value="key") String spaceKey) {
        try {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            Space space = this.spaceManager.getSpace(spaceKey);
            if (space != null && user != null && this.spacePermissionManager.hasPermission("VIEWSPACE", space, (User)user)) {
                this.favouriteManager.removeSpaceFromFavourites((User)user, space);
                return Response.ok().build();
            }
            log.warn("Cannot remove space favourite: Permissions or space doesn't exist");
            return Response.notModified().build();
        }
        catch (Exception e) {
            log.error("Cannot remove space favourite", (Throwable)e);
            return Response.serverError().entity((Object)new Gson().toJson(e.getMessage())).build();
        }
    }
}

