/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.content;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultXhtmlContent;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.PermissionHelper;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.DefaultImageUtils;
import com.atsistemas.confluence.app.utils.MacroHelper;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ExtractedPanel
extends DazzleMacro {
    private static final Logger log = LoggerFactory.getLogger(ExtractedPanel.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ConfluenceImport
    private PageManager pageManager;
    @ConfluenceImport
    private SpaceManager spaceManager;
    @ConfluenceImport
    private SettingsManager settingsManager;
    private PermissionHelper permissionHelper;
    @ConfluenceImport
    private I18NBean i18nHelper;

    @Autowired
    public ExtractedPanel(PageBuilderService pageBuilderService, @ConfluenceComponent DazzleLicenseService dazzleLicenseService, PageManager pageManager, SpaceManager spaceManager, SettingsManager settingsManager) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.settingsManager = settingsManager;
        this.i18nHelper = (I18NBean)ComponentLocator.getComponent(I18NBean.class);
        this.permissionHelper = (PermissionHelper)ComponentLocator.getComponent(PermissionHelper.class);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        parameters.put("body", body);
        String bodyC = null;
        try {
            String pageName = MacroHelper.getPageFromParams(parameters.get("page"));
            String space = MacroHelper.getSpaceFromParams(parameters.get("page"));
            log.debug("Extracted panel for page {} and space {}", (Object)pageName, (Object)space);
            AbstractPage page = this.getContent(StringUtils.defaultString((String)space, (String)conversionContext.getPageContext().getSpaceKey()), pageName);
            DefaultXhtmlContent dc = (DefaultXhtmlContent)ComponentLocator.getComponent(DefaultXhtmlContent.class);
            String storage = this.getExcerpt(page, parameters.get("name"));
            storage = this.fixFontData(storage);
            DefaultConversionContext cc = new DefaultConversionContext((RenderContext)new PageContext((ContentEntityObject)page));
            cc.getPageContext().getRenderMode().renderMacros();
            bodyC = this.getBodyFromExtractablePanel(dc.convertStorageToView(storage, (ConversionContext)cc));
        }
        catch (XhtmlException | XMLStreamException e) {
            log.error("Error rendering excerpt", e);
        }
        if (bodyC == null) {
            parameters.put("showBody", "false");
            parameters.put("notFoundImg", DefaultImageUtils.getNotFoundUmage(this.settingsManager));
            parameters.put("notFoundDesc", this.i18nHelper.getText("com.atsistemas.confluence.app.awesome-macros.default.not-found"));
        } else {
            parameters.put("showBody", "true");
            parameters.put("excerptHtml", bodyC);
        }
        String templatePath = "templates/extracted-panel.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, parameters);
    }

    private boolean checkUserPermissions(AbstractPage page, ConfluenceUser confluenceUser) {
        return this.permissionHelper.canViewPage((User)confluenceUser, page.getId());
    }

    private AbstractPage getContent(String space, String page) {
        Space sp;
        Optional<BlogPost> blogpost;
        Page ab = this.pageManager.getPage(space, page);
        if (ab == null && (blogpost = this.pageManager.getBlogPosts(sp = this.spaceManager.getSpace(space), true).stream().filter(x -> page.equals(x.getTitle())).findFirst()).isPresent()) {
            ab = (AbstractPage)blogpost.get();
        }
        return ab;
    }

    private String getBodyFromExtractablePanel(String view) {
        Document document = Jsoup.parse((String)view);
        Elements elements = document.getElementsByTag("ac:rich-text-body");
        return elements.html();
    }

    private String getExcerpt(AbstractPage page, String name) {
        String body = page.getBodyAsString();
        if (StringUtils.isNotBlank((CharSequence)body)) {
            Document document = Jsoup.parse((String)body);
            document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
            Elements panels = document.getElementsByAttributeValue("ac:name", "am-extractable-panel");
            if (!panels.isEmpty()) {
                for (Element panel : panels) {
                    for (Element innerAttr : panel.getElementsByTag("ac:parameter")) {
                        if (!innerAttr.attr("ac:name").equalsIgnoreCase("name") || !innerAttr.text().equals(name)) continue;
                        return panel.html();
                    }
                }
            }
        }
        return null;
    }

    private String fixFontData(String storage) {
        if (storage != null) {
            storage = storage.replace("<ac:plain-text-body>", "<ac:parameter ac:name=\"textc\">");
            storage = storage.replace("</ac:plain-text-body>", "</ac:parameter>");
        }
        return storage;
    }
}

