/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.MacroHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class PanelVideo
extends DazzleMacro {
    private final Logger log = Logger.getLogger(PanelVideo.class);
    private static final String SRC = "src";
    private static final String NAME = "name";
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ConfluenceImport
    private PageManager pageManager;
    @ConfluenceImport
    private AttachmentManager attachmentManager;
    @ConfluenceImport
    private SettingsManager settingsManager;

    @Autowired
    public PanelVideo(PageBuilderService pageBuilderService, PageManager pageManager, AttachmentManager attachmentManager, SettingsManager settingsManager, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.settingsManager = settingsManager;
    }

    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        HashMap<String, Object> contextParam = new HashMap<String, Object>();
        contextParam.putAll(parameters);
        contextParam.put("body", body);
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma");
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        if (macroDefinition.getMacroId().isDefined()) {
            contextParam.put("macroId", ((MacroId)macroDefinition.getMacroId().get()).getId());
        }
        String src = this.getVideoUrl(parameters, MacroHelper.getPageFromContext(this.pageManager, conversionContext));
        contextParam.put(SRC, src);
        contextParam.put("centered", "centered".equals(parameters.get("contentType")));
        String templatePath = "templates/panel-video.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, contextParam);
    }

    private String getVideoUrl(Map<String, String> parameters, AbstractPage page) {
        if (StringUtils.isNotBlank((CharSequence)parameters.get(NAME)) && page != null) {
            return this.getAttachmentSource(page, parameters.get(NAME));
        }
        return null;
    }

    private String getAttachmentSource(AbstractPage page, String attachmentName) {
        Attachment at = this.attachmentManager.getAttachment((ContentEntityObject)page, attachmentName);
        if (at != null) {
            return this.settingsManager.getGlobalSettings().getBaseUrl() + at.getDownloadPathWithoutVersionOrApiRevision();
        }
        return null;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

