/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.component.vo.LinkItemVO;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.BaseURLUpdater;
import com.atsistemas.confluence.app.utils.MacroHelper;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class PanelImage
extends DazzleMacro {
    private static final String NAVIGATION = "navigation";
    private final Logger log = Logger.getLogger(PanelImage.class);
    private static final String NAME = "name";
    private static final String IMAGE = "image";
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ConfluenceImport
    private PageManager pageManager;
    @ConfluenceImport
    private AttachmentManager attachmentManager;
    @ConfluenceImport
    private SettingsManager settingsManager;
    @ConfluenceImport
    private SpaceManager spaceManager;

    @Autowired
    public PanelImage(PageBuilderService pageBuilderService, PageManager pageManager, AttachmentManager attachmentManager, SettingsManager settingsManager, @ConfluenceComponent DazzleLicenseService dazzleLicenseService, SpaceManager spaceManager) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.settingsManager = settingsManager;
        this.spaceManager = spaceManager;
    }

    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        parameters.put("body", body);
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma");
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        if (macroDefinition.getMacroId().isDefined()) {
            parameters.put("macroId", ((MacroId)macroDefinition.getMacroId().get()).getId());
        }
        String src = this.getImageUrl(parameters, MacroHelper.getPageFromContext(this.pageManager, conversionContext));
        parameters.put(IMAGE, src);
        parameters.put(NAVIGATION, this.getUrl(parameters, conversionContext));
        String templatePath = "templates/panel-image.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, parameters);
    }

    private String getImageUrl(Map<String, String> parameters, AbstractPage page) {
        if (StringUtils.isNotBlank((CharSequence)parameters.get(IMAGE))) {
            return parameters.get(IMAGE);
        }
        if (StringUtils.isNotBlank((CharSequence)parameters.get(NAME)) && page != null) {
            return this.getAttachmentSource(page, parameters.get(NAME));
        }
        return null;
    }

    private String getAttachmentSource(AbstractPage page, String attachmentName) {
        Attachment at = this.attachmentManager.getAttachment((ContentEntityObject)page, attachmentName);
        if (at != null) {
            return this.settingsManager.getGlobalSettings().getBaseUrl() + at.getDownloadPathWithoutVersionOrApiRevision();
        }
        return null;
    }

    private String getUrl(Map<String, String> parameters, ConversionContext conversionContext) {
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        LinkItemVO linkIcon = this.getLink(parameters.get("link"), parameters.get("pageLink"), conversionContext.getPageContext().getSpaceKey(), baseUrl);
        return linkIcon.getUrlPrecedencePage();
    }

    private LinkItemVO getLink(String url, String page, String space, String baseUrl) {
        LinkItemVO vo = new LinkItemVO();
        vo.setFullPage(page);
        vo.setLink(BaseURLUpdater.getUrl(url, this.settingsManager));
        vo.setPageTitle(MacroHelper.getPageFromParams(page));
        vo.setSpace(StringUtils.defaultString((String)MacroHelper.getSpaceFromParams(page), (String)space));
        vo.setConfluenceBaseUrl(baseUrl);
        vo.setPageUrl(this.getPageUrl(vo.getSpace(), vo.getPageTitle()));
        return vo;
    }

    private AbstractPage getContent(String space, String page) {
        if (page != null && space != null) {
            Space sp;
            Optional<BlogPost> blogpost;
            Page ab = this.pageManager.getPage(space, page);
            if (ab == null && (blogpost = this.pageManager.getBlogPosts(sp = this.spaceManager.getSpace(space), true).stream().filter(x -> page.equals(x.getTitle())).findFirst()).isPresent()) {
                ab = (AbstractPage)blogpost.get();
            }
            return ab;
        }
        return null;
    }

    private String getPageUrl(String space, String page) {
        try {
            AbstractPage ab = this.getContent(space, page);
            if (ab != null) {
                return ab.getUrlPath();
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error obtaining page url", (Throwable)e);
        }
        return null;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

