/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.api.service.datetime.DateFormatService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.component.vo.FeedItemVO;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class InstagramFeed
extends DazzleMacro {
    private final Logger log = LoggerFactory.getLogger(InstagramFeed.class);
    @ComponentImport
    private PageBuilderService pageBuilderService;
    @ConfluenceImport
    private PageManager pageManager;
    @ConfluenceImport
    private SettingsManager settingsManager;
    @ConfluenceImport
    private SpaceManager spaceManager;
    @ConfluenceImport
    private DateFormatService dateFormatService;

    @Autowired
    public InstagramFeed(PageBuilderService pageBuilderService, PageManager pageManager, SettingsManager settingsManager, SpaceManager spaceManager, DateFormatService dateFormatService, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.dateFormatService = dateFormatService;
        this.settingsManager = settingsManager;
    }

    public String execute(Map<String, String> params, String body, ConversionContext context) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", params);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.vcomponents:ats-summary-resources");
        return VelocityUtils.getRenderedTemplate((String)"templates/rrss-feed.vm", this.getTemplateContext(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private Optional<JSONObject> getInstagramFeed(String name) {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            CloseableHttpResponse response;
            block13: {
                Optional<JSONObject> optional;
                HttpGet httpget = new HttpGet("https://www.instagram.com/" + name + "/?__a=1");
                httpget.addHeader("accept", "application/json;odata=verbose");
                this.log.debug("Executing request {}", (Object)httpget.getRequestLine());
                response = httpclient.execute((HttpUriRequest)httpget);
                try {
                    this.log.debug("Request result {}", (Object)response.getStatusLine());
                    if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) break block13;
                    String document = EntityUtils.toString((HttpEntity)response.getEntity());
                    this.log.debug("Document content {}", (Object)document);
                    JSONObject json = new JSONObject(document);
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    optional = Optional.of(json);
                }
                catch (Throwable throwable) {
                    response.close();
                    throw throwable;
                }
                response.close();
                return optional;
            }
            this.log.warn("Instagram feed not found {}", (Object)name);
            Optional<JSONObject> optional = Optional.empty();
            response.close();
            return optional;
        }
        catch (Exception e) {
            this.log.error("Error retrieving data from Instagram", (Throwable)e);
            return Optional.empty();
        }
    }

    private List<FeedItemVO> getFeedItems(JSONObject instagramFeed, int maxEntries) {
        if (instagramFeed != null) {
            try {
                ArrayList<FeedItemVO> feedItems = new ArrayList<FeedItemVO>();
                JSONArray entries = instagramFeed.getJSONObject("graphql").getJSONObject("user").getJSONObject("edge_owner_to_timeline_media").getJSONArray("edges");
                String name = instagramFeed.getJSONObject("graphql").getJSONObject("user").getString("username");
                for (int index = 0; index < maxEntries && entries.iterator().hasNext(); ++index) {
                    FeedItemVO vo = new FeedItemVO();
                    JSONObject current = entries.getJSONObject(index);
                    vo.setContent(current.getJSONObject("node").getJSONObject("edge_media_to_caption").getJSONArray("edges").getJSONObject(0).getJSONObject("node").getString("text"));
                    vo.setImageSrc(current.getJSONObject("node").getString("thumbnail_src"));
                    vo.setSource("https://www.instagram.com/" + name + "/p/" + current.getJSONObject("node").getString("shortcode"));
                    feedItems.add(vo);
                }
                return feedItems;
            }
            catch (Exception e) {
                this.log.error("Cannot parse feed", (Throwable)e);
            }
        }
        return new ArrayList<FeedItemVO>();
    }

    private Map<String, Object> getTemplateContext(Map<String, String> params) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (params.get("name") != null) {
            Optional<JSONObject> feed = this.getInstagramFeed(params.get("name"));
            int entries = Integer.parseInt(params.getOrDefault("entries", "3"));
            if (feed.isPresent()) {
                context.put("feeditems", this.getFeedItems(feed.get(), entries));
            }
        }
        context.putAll(params);
        return context;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

