/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.BaseURLUpdater;
import com.atsistemas.confluence.app.utils.DefaultImageUtils;
import com.atsistemas.confluence.app.utils.MacroHelper;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class Image
extends DazzleMacro {
    private static final String NAME = "name";
    private static final String IMAGE = "image";
    private final Logger log = Logger.getLogger(Image.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ConfluenceImport
    private PageManager pageManager;
    @ConfluenceImport
    private AttachmentManager attachmentManager;
    @ConfluenceImport
    private SettingsManager settingsManager;

    @Autowired
    public Image(PageBuilderService pageBuilderService, PageManager pageManager, AttachmentManager attachmentManager, SettingsManager settingsManager, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.settingsManager = settingsManager;
    }

    public String execute(Map<String, String> parameters, String string, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma");
        String templatePath = "templates/image.vm";
        String src = this.getImageUrl(parameters, MacroHelper.getPageFromContext(this.pageManager, conversionContext));
        parameters.put("src", src);
        parameters.put("height", parameters.getOrDefault("height", "100%"));
        parameters.put("width", parameters.getOrDefault("width", "100%"));
        parameters.put("link", BaseURLUpdater.getUrl(parameters.get("link"), this.settingsManager));
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        if (macroDefinition.getMacroId().isDefined()) {
            parameters.put("macroId", ((MacroId)macroDefinition.getMacroId().get()).getId());
        }
        return VelocityUtils.getRenderedTemplate((String)templatePath, parameters);
    }

    private String getImageUrl(Map<String, String> parameters, AbstractPage page) {
        if (StringUtils.isNotBlank((CharSequence)parameters.get(IMAGE))) {
            return parameters.get(IMAGE);
        }
        if (StringUtils.isNotBlank((CharSequence)parameters.get(NAME)) && page != null) {
            String url = this.getAttachmentSource(page, parameters.get(NAME));
            return (String)StringUtils.defaultIfBlank((CharSequence)url, (CharSequence)DefaultImageUtils.getDefaultImage(this.settingsManager));
        }
        return DefaultImageUtils.getDefaultImage(this.settingsManager);
    }

    private String getAttachmentSource(AbstractPage page, String attachmentName) {
        Attachment at = this.attachmentManager.getAttachment((ContentEntityObject)page, attachmentName);
        if (at != null) {
            return this.settingsManager.getGlobalSettings().getBaseUrl() + at.getDownloadPathWithoutVersionOrApiRevision();
        }
        return null;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

