/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class Font
extends DazzleMacro {
    private static final String DEFAULT_FONT = "Ubuntu-M.ttf";
    private static final Logger log = LoggerFactory.getLogger(Font.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ComponentImport
    private final SettingsManager settingsManager;

    @Autowired
    public Font(PageBuilderService pageBuilderService, SettingsManager settingsManager, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.settingsManager = settingsManager;
    }

    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        boolean isParagraph = Boolean.parseBoolean(parameters.getOrDefault("paragraph", "false"));
        if (StringUtils.isBlank((CharSequence)body)) {
            body = parameters.get("textc");
        }
        if (isParagraph) {
            contextMap.put("paragraphs", this.getBodyAsParagraphs(body));
        } else {
            contextMap.put("body", body);
        }
        contextMap.putAll(parameters);
        contextMap.put("paragraph", isParagraph);
        contextMap.put("macroId", macroDefinition.getMacroId().map(MacroId::getId).getOrNull());
        contextMap.put("uuid", UUID.randomUUID().toString());
        contextMap.put("fontColor", this.getFontColor(parameters));
        contextMap.put("fontSize", this.getParameterOrEmpty(parameters, "size"));
        contextMap.put("lineHeight", this.getLineHeight(parameters));
        contextMap.put("textShadow", this.getParameterOrEmpty(parameters, "shadow"));
        contextMap.put("fontUrl", this.getFontUrl(parameters));
        String templatePath = "templates/font.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, contextMap);
    }

    private List<String> getBodyAsParagraphs(String body) {
        if (body != null) {
            return Arrays.stream(body.split("\n")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    String getFontUrl(Map<String, String> parameters) {
        String fontUrl = this.getParameterOrEmpty(parameters, "font");
        if (fontUrl.isEmpty()) {
            String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
            String font = parameters.getOrDefault("font", DEFAULT_FONT);
            fontUrl = this.getUrlForStandardFont(baseUrl, font.replace("\n", "").trim());
        }
        return fontUrl;
    }

    String getParameterOrEmpty(Map<String, String> parameters, String key) {
        return parameters.getOrDefault(key, "");
    }

    String getUrlForStandardFont(String baseUrl, String fontName) {
        return baseUrl + "/download/resources/com.atsistemas.confluence.app.awesome-macros/fonts/" + fontName;
    }

    String getFontColor(Map<String, String> parameters) {
        String fontColor = this.getParameterOrEmpty(parameters, "color");
        if (fontColor.isEmpty()) {
            fontColor = this.getParameterOrEmpty(parameters, "colors");
        }
        return fontColor;
    }

    String getLineHeight(Map<String, String> parameters) {
        String lineHeight = this.getParameterOrEmpty(parameters, "height");
        if (lineHeight.isEmpty()) {
            lineHeight = "normal";
        }
        return lineHeight;
    }
}

