/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.component.vo.FaqItemVO;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class FaqContainer
extends DazzleMacro {
    private final Logger log = Logger.getLogger(FaqContainer.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;

    @Autowired
    public FaqContainer(PageBuilderService pageBuilderService, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
    }

    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("faqItems", this.getFaqItems(Jsoup.parse((String)body)));
        params.put("macroId", macroDefinition.getMacroId().map(MacroId::getId).getOrNull());
        params.put("autoDisplay", "true");
        String templatePath = "templates/faq-container.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, params);
    }

    private List<FaqItemVO> getFaqItems(Document document) {
        ArrayList<FaqItemVO> faqItems = new ArrayList<FaqItemVO>();
        if (document != null) {
            Elements buttons = document.getElementsByClass("faq-item");
            for (Element e : buttons) {
                FaqItemVO item = new FaqItemVO();
                item.setColor(StringUtils.defaultString((String)e.attr("data-color"), (String)""));
                item.setLabel(StringUtils.defaultString((String)e.attr("data-label"), (String)""));
                item.setValueHtml(StringUtils.defaultString((String)e.html(), (String)""));
                item.setMacroId(StringUtils.defaultString((String)e.attr("data-macro-id"), (String)""));
                faqItems.add(item);
            }
        }
        return faqItems;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

