/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.api.service.datetime.DateFormatService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultRenderer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.DefaultImageUtils;
import com.atsistemas.confluence.app.utils.MacroHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class ContentSummary
extends DazzleMacro {
    private static final String SRC = "src";
    private static final Logger log = LoggerFactory.getLogger(ContentSummary.class);
    @ComponentImport
    private PageBuilderService pageBuilderService;
    @ConfluenceImport
    private PageManager pageManager;
    @ConfluenceImport
    private SettingsManager settingsManager;
    @ConfluenceImport
    private SpaceManager spaceManager;
    @ConfluenceImport
    private DateFormatService dateFormatService;
    @ConfluenceImport
    private AttachmentManager attachmentManager;

    @Autowired
    public ContentSummary(PageBuilderService pageBuilderService, PageManager pageManager, SettingsManager settingsManager, SpaceManager spaceManager, DateFormatService dateFormatService, AttachmentManager attachmentManager, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.dateFormatService = dateFormatService;
        this.settingsManager = settingsManager;
        this.attachmentManager = attachmentManager;
    }

    public String execute(Map<String, String> params, String body, ConversionContext context) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", params);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.vcomponents:ats-summary-resources").requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma");
        return VelocityUtils.getRenderedTemplate((String)"templates/content-summary.vm", this.getTemplateContext(this.getSpaceFromContext(context, params.get("page")), params));
    }

    private String getSpaceFromContext(ConversionContext context, String page) {
        String space = StringUtils.isNotBlank((CharSequence)page) && page.indexOf(58) > 0 ? page.substring(0, page.indexOf(58)) : context.getPageContext().getSpaceKey();
        return space;
    }

    private Map<String, Object> getTemplateContext(String space, Map<String, String> params) {
        AbstractPage pageObject;
        HashMap<String, Object> context = new HashMap<String, Object>();
        String page = MacroHelper.getPageFromParams(params.get("page"));
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{space, page}) && (pageObject = this.getContent(space, page)) != null) {
            context.put("excerptHtml", this.getExcerpt(pageObject));
            context.put("pagetitle", pageObject.getTitle());
            context.put("user", pageObject.getCreator() != null ? pageObject.getCreator().getFullName() : null);
            SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormatService.getDateFormatPatternForUser());
            context.put("date", pageObject.getCreationDate() != null ? sdf.format(pageObject.getCreationDate()) : null);
            context.put("spaceName", pageObject.getSpace().getName());
            context.put("link", this.settingsManager.getGlobalSettings().getBaseUrl() + pageObject.getUrlPath());
            DefaultRenderer dr = (DefaultRenderer)ComponentLocator.getComponent(DefaultRenderer.class);
            String imgParam = params.get("image");
            this.getImageForCard(context, pageObject, dr, imgParam);
        }
        context.put("tagList", this.getTagList(params.get("tags")));
        context.putAll(params);
        return context;
    }

    private void getImageForCard(Map<String, Object> context, AbstractPage pageObject, DefaultRenderer dr, String imgParam) {
        if (imgParam != null) {
            if (imgParam.equals("first")) {
                context.put(SRC, this.scanBodyForImage(dr.render((ContentEntityObject)pageObject), pageObject).orElse(null));
            } else if (imgParam.equals("default")) {
                context.put(SRC, DefaultImageUtils.getDocumentDefaultImage(this.settingsManager));
            }
        } else {
            context.put(SRC, this.scanBodyForImage(dr.render((ContentEntityObject)pageObject), pageObject).orElse(null));
        }
    }

    private String getExcerpt(AbstractPage page) {
        String content = page.getBodyAsString();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            Document doc = Jsoup.parse((String)content);
            for (Element element : doc.getElementsByTag("ac:parameter")) {
                element.remove();
            }
            return StringUtils.left((String)doc.text(), (int)255) + "...";
        }
        return null;
    }

    private AbstractPage getContent(String space, String page) {
        if (page != null && space != null) {
            Space sp;
            Optional<BlogPost> blogpost;
            Page ab = this.pageManager.getPage(space, page);
            if (ab == null && (blogpost = this.pageManager.getBlogPosts(sp = this.spaceManager.getSpace(space), true).stream().filter(x -> page.equals(x.getTitle())).findFirst()).isPresent()) {
                ab = (AbstractPage)blogpost.get();
            }
            return ab;
        }
        return null;
    }

    private Optional<String> scanBodyForImage(String body, AbstractPage page) {
        Document document = Jsoup.parse((String)body);
        Elements elements = document.getElementsByTag("img");
        Optional<Element> firstImage = elements.stream().filter(el -> el.attr("data-macro-name").equals("am-image") || el.attr("data-macro-name").isEmpty()).findFirst();
        if (firstImage.isPresent()) {
            Element image = firstImage.get();
            if ("am-image".equals(image.attr("data-macro-name"))) {
                log.debug("am-image {}", (Object)image);
                String params = image.attr("data-macro-parameters");
                int startOffset = 0;
                startOffset = params.contains("image=") ? params.indexOf("image=") + 6 : params.indexOf("name=") + 5;
                String url = params.substring(startOffset);
                int endIndex = url.indexOf(124);
                if (endIndex > 0) {
                    url = url.substring(0, endIndex);
                }
                return Optional.of(url);
            }
            return Optional.of(image.attr(SRC));
        }
        return Optional.of(DefaultImageUtils.getDocumentDefaultImage(this.settingsManager));
    }

    private String getAttachmentSource(AbstractPage page, String attachmentName) {
        Attachment at = this.attachmentManager.getAttachment((ContentEntityObject)page, attachmentName);
        if (at != null) {
            return this.settingsManager.getGlobalSettings().getBaseUrl() + at.getDownloadPathWithoutVersionOrApiRevision();
        }
        return null;
    }

    private List<String> getTagList(String tags) {
        if (StringUtils.isNotBlank((CharSequence)tags)) {
            return Arrays.asList(tags.split("\\s"));
        }
        return new ArrayList<String>();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

