/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class CardMap
extends DazzleMacro {
    private static final String HAS_FOOTER = "hasFooter";
    private static final String RIGHT_URL = "right_url";
    private static final String LEFT_URL = "left_url";
    private static final Logger log = Logger.getLogger(CardMap.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ConfluenceImport
    private PageManager pageManager;
    @ConfluenceImport
    private SettingsManager settingsManager;
    @ConfluenceImport
    private AttachmentManager attachmentManager;

    @Autowired
    public CardMap(PageBuilderService pageBuilderService, PageManager pageManager, SettingsManager settingsManager, AttachmentManager attachmentManager, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.pageManager = pageManager;
        this.settingsManager = settingsManager;
        this.attachmentManager = attachmentManager;
    }

    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma").requireWebResource("com.atsistemas.confluence.app.awesome-macros:font-awesome");
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("height", parameters.getOrDefault("height", "400px"));
        contextMap.put("mapQuery", parameters.getOrDefault("mapQuery", "atSistemas Las Rozas, Madrid"));
        contextMap.put("title", parameters.get("title"));
        contextMap.put("openingHours", parameters.get("openingHours"));
        contextMap.put("pinAddress", parameters.get("pinAddress"));
        contextMap.put("tagList", this.getTagList(parameters.get("tags")));
        contextMap.put("tags", parameters.get("tags"));
        String templatePath = "templates/card-map.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, contextMap);
    }

    private List<String> getTagList(String tags) {
        if (StringUtils.isNotBlank((CharSequence)tags)) {
            return Arrays.asList(tags.split("\\s"));
        }
        return new ArrayList<String>();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

