/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.component.vo.LinkItemVO;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.BaseURLUpdater;
import com.atsistemas.confluence.app.utils.DefaultImageUtils;
import com.atsistemas.confluence.app.utils.MacroHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class CardImage
extends DazzleMacro {
    private static final String HAS_FOOTER = "hasFooter";
    private static final String RIGHT_URL = "right_url";
    private static final String LEFT_URL = "left_url";
    private static final Logger log = Logger.getLogger(CardImage.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ConfluenceImport
    private PageManager pageManager;
    @ConfluenceImport
    private SettingsManager settingsManager;
    @ConfluenceImport
    private AttachmentManager attachmentManager;
    @ComponentImport
    private final SpaceManager spaceManager;

    @Autowired
    public CardImage(PageBuilderService pageBuilderService, PageManager pageManager, SettingsManager settingsManager, AttachmentManager attachmentManager, @ConfluenceComponent DazzleLicenseService dazzleLicenseService, SpaceManager spaceManager) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.pageManager = pageManager;
        this.settingsManager = settingsManager;
        this.attachmentManager = attachmentManager;
        this.spaceManager = spaceManager;
    }

    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma").requireWebResource("com.atsistemas.confluence.app.awesome-macros:cards");
        String templatePath = "templates/card-image.vm";
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("body", body);
        contextMap.put("tagList", this.getTagList(parameters.get("tags")));
        contextMap.putAll(parameters);
        return VelocityUtils.getRenderedTemplate((String)templatePath, this.getTemplateContext(MacroHelper.getPageFromContext(this.pageManager, conversionContext), contextMap));
    }

    private List<String> getTagList(String tags) {
        if (StringUtils.isNotBlank((CharSequence)tags)) {
            return Arrays.asList(tags.split("\\s"));
        }
        return new ArrayList<String>();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private LinkItemVO getLink(String url, String page, String space, String baseUrl) {
        LinkItemVO vo = new LinkItemVO();
        vo.setFullPage(page);
        vo.setLink(BaseURLUpdater.getUrl(url, this.settingsManager));
        vo.setPageTitle(MacroHelper.getPageFromParams(page));
        vo.setSpace(StringUtils.defaultString((String)MacroHelper.getSpaceFromParams(page), (String)space));
        vo.setConfluenceBaseUrl(baseUrl);
        vo.setPageUrl(this.getPageUrl(vo.getSpace(), vo.getPageTitle()));
        return vo;
    }

    private String getPageUrl(String space, String page) {
        try {
            AbstractPage ab = this.getContent(space, page);
            if (ab != null) {
                return ab.getUrlPath();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error obtaining page url", (Throwable)e);
        }
        return null;
    }

    private AbstractPage getContent(String space, String page) {
        if (page != null && space != null) {
            Space sp;
            Optional<BlogPost> blogpost;
            Page ab = this.pageManager.getPage(space, page);
            if (ab == null && (blogpost = this.pageManager.getBlogPosts(sp = this.spaceManager.getSpace(space), true).stream().filter(x -> page.equals(x.getTitle())).findFirst()).isPresent()) {
                ab = (AbstractPage)blogpost.get();
            }
            return ab;
        }
        return null;
    }

    private Map<String, Object> getTemplateContext(AbstractPage page, Map<String, Object> parameters) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        LinkItemVO leftLink = this.getLink((String)parameters.get("leftLink"), (String)parameters.get("lpage"), (String)parameters.get("space"), baseUrl);
        LinkItemVO rightLink = this.getLink((String)parameters.get("rightLink"), (String)parameters.get("rpage"), (String)parameters.get("space"), baseUrl);
        context.put(LEFT_URL, leftLink.getUrlPrecedencePage());
        context.put(RIGHT_URL, rightLink.getUrlPrecedencePage());
        context.put(HAS_FOOTER, parameters.get("leftButton") != null || parameters.get("rightButton") != null);
        String urlImage = (String)parameters.get("image");
        if (StringUtils.isNotBlank((CharSequence)((String)parameters.get("image")))) {
            context.put("src", urlImage);
        } else if (StringUtils.isNotBlank((CharSequence)((String)parameters.get("name"))) && page != null) {
            String url = this.getAttachmentSource(page, (String)parameters.get("name"));
            context.put("src", StringUtils.defaultIfBlank((CharSequence)url, (CharSequence)DefaultImageUtils.getDefaultImage(this.settingsManager)));
        } else {
            context.put("src", DefaultImageUtils.getDefaultImage(this.settingsManager));
        }
        context.putAll(parameters);
        return context;
    }

    private String getAttachmentSource(AbstractPage page, String attachmentName) {
        Attachment at = this.attachmentManager.getAttachment((ContentEntityObject)page, attachmentName);
        if (at != null) {
            return this.settingsManager.getGlobalSettings().getBaseUrl() + at.getDownloadPathWithoutVersionOrApiRevision();
        }
        return null;
    }
}

