/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.component.vo.CardListVO;
import com.atsistemas.confluence.app.awesomemacros.component.vo.CardVO;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class CardContainer
extends DazzleMacro {
    private static final Logger log = Logger.getLogger(CardContainer.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;

    @Autowired
    public CardContainer(PageBuilderService pageBuilderService, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma").requireWebResource("com.atsistemas.confluence.app.awesome-macros:card-container");
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.putAll(parameters);
        contextMap.put("body", body);
        CardListVO cardListVO = this.extractCards(body);
        contextMap.put("cards", cardListVO.getCards());
        ArrayList<String> cardTags = new ArrayList<String>(cardListVO.getTags());
        Collections.sort(cardTags);
        contextMap.put("cardTags", cardTags);
        contextMap.put("style", parameters.get("style"));
        contextMap.put("cardsPerRow", 12 / Integer.parseInt(parameters.getOrDefault("cardsPerRow", "3")));
        String templatePath = "templates/card-container.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, contextMap);
    }

    private CardListVO extractCards(String body) {
        HashSet<String> tags = new HashSet<String>();
        ArrayList<CardVO> cards = new ArrayList<CardVO>();
        if (body != null) {
            Document document = Jsoup.parse((String)body);
            Elements buttons = document.getElementsByClass("card");
            for (Element e : buttons) {
                CardVO card = new CardVO();
                card.setCardHtml(e.outerHtml());
                card.setTags(StringUtils.defaultString((String)e.attr("data-tag"), (String)"*"));
                tags.addAll(document.getElementsByClass("tag").stream().map(Element::text).collect(Collectors.toSet()));
                cards.add(card);
            }
        }
        CardListVO vo = new CardListVO();
        vo.setCards(cards);
        vo.setTags(tags);
        return vo;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

