/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.renderer.RenderedContentStore;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.component.vo.LinkItemVO;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.BaseURLUpdater;
import com.atsistemas.confluence.app.utils.MacroHelper;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class Button
extends DazzleMacro {
    private static final String URL = "url";
    private static final Logger log = Logger.getLogger(Button.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ConfluenceImport
    private PageManager pageManager;
    @ConfluenceImport
    private SpaceManager spaceManager;
    @ConfluenceImport
    private SettingsManager settingsManager;

    @Autowired
    public Button(PageBuilderService pageBuilderService, PageManager pageManager, @ConfluenceComponent DazzleLicenseService dazzleLicenseService, SpaceManager spaceManager, SettingsManager settingsManager) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.settingsManager = settingsManager;
    }

    public String execute(Map<String, String> parameters, String string, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma").requireWebResource("com.atsistemas.confluence.app.awesome-macros:font-awesome");
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        if (macroDefinition.getMacroId().isDefined()) {
            parameters.put("macroId", ((MacroId)macroDefinition.getMacroId().get()).getId());
        }
        parameters.put(URL, this.getUrl(parameters, conversionContext));
        parameters.put("tooltip", parameters.getOrDefault("tooltip", parameters.get("text")));
        String templatePath = "templates/button.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, parameters);
    }

    private LinkItemVO getLink(String url, String page, String space, String baseUrl) {
        LinkItemVO vo = new LinkItemVO();
        vo.setFullPage(page);
        vo.setLink(BaseURLUpdater.getUrl(url, this.settingsManager));
        vo.setPageTitle(MacroHelper.getPageFromParams(page));
        vo.setSpace(StringUtils.defaultString((String)MacroHelper.getSpaceFromParams(page), (String)space));
        vo.setConfluenceBaseUrl(baseUrl);
        vo.setPageUrl(this.getPageUrl(vo.getSpace(), vo.getPageTitle()));
        return vo;
    }

    private AbstractPage getContent(String space, String page) {
        if (page != null && space != null) {
            Space sp;
            Optional<BlogPost> blogpost;
            Page ab = this.pageManager.getPage(space, page);
            if (ab == null && (blogpost = this.pageManager.getBlogPosts(sp = this.spaceManager.getSpace(space), true).stream().filter(x -> page.equals(x.getTitle())).findFirst()).isPresent()) {
                ab = (AbstractPage)blogpost.get();
            }
            return ab;
        }
        return null;
    }

    private String getPageUrl(String space, String page) {
        try {
            AbstractPage ab = this.getContent(space, page);
            if (ab != null) {
                return ab.getUrlPath();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error obtaining page url", (Throwable)e);
        }
        return null;
    }

    private String getUrl(Map<String, String> parameters, ConversionContext conversionContext) {
        String url = parameters.get(URL);
        if (url != null && url.startsWith("#")) {
            return this.changeUrlForAnchors(parameters, conversionContext);
        }
        if (parameters.get("page") != null) {
            String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
            LinkItemVO linkIcon = this.getLink(parameters.get(URL), parameters.get("page"), conversionContext.getPageContext().getSpaceKey(), baseUrl);
            return linkIcon.getUrlPrecedencePage();
        }
        return BaseURLUpdater.getUrl(url, this.settingsManager);
    }

    private String changeUrlForAnchors(Map<String, String> parameters, ConversionContext conversionContext) {
        AbstractPage page = MacroHelper.getPageFromContext(this.pageManager, conversionContext);
        String url = parameters.get(URL);
        if (page != null) {
            String urlPathName = page.getUrlPath().substring(page.getUrlPath().lastIndexOf("/") + 1);
            return urlPathName + "#" + page.getTitle().replaceAll("\\s|-", "") + "-" + StringUtils.defaultString((String)RenderedContentStore.stripTokens((String)url.substring(1))).trim();
        }
        return "#";
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

