/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class AccordionsContainer
extends DazzleMacro {
    private static final Logger log = Logger.getLogger(AccordionsContainer.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;

    @Autowired
    public AccordionsContainer(PageBuilderService pageBuilderService, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
    }

    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma");
        String expandedAccordionIndex = parameters.get("expandedAccordion");
        Elements accordionElements = Jsoup.parse((String)body).children();
        if (NumberUtils.isDigits((String)expandedAccordionIndex)) {
            Optional.ofNullable(expandedAccordionIndex).map(Long::parseLong).ifPresent(index -> accordionElements.stream().skip(index <= 0L ? 0L : index - 1L).findFirst().ifPresent(element -> element.addClass("is-active")));
        }
        parameters.put("macroId", (String)macroDefinition.getMacroId().map(MacroId::getId).getOrNull());
        parameters.put("accordionsAsHtml", accordionElements.outerHtml());
        String templatePath = "templates/accordions-container.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, parameters);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

