AJS.$(document).ready(function() {
	
	//Implement closeable functionality
	AJS.$(".am-closeable").click(function(){
		let macroId = AJS.$(this).attr("data-macro-id");
		AJS.$("div.b4c[data-macro-id='" + macroId + "'").remove();
	});
	
	
	//Make clickable buttons
	AJS.$(".am-clickable").click(function(){
		let macroId = AJS.$(this).attr("data-macro-id");
		AJS.$("a.b4c[data-macro-id='" + macroId + "'")[0].click(); //0 because jquery
	});
	
	//Make clickable images
	AJS.$(".am-img-clickable").each(function(){
		let link = AJS.$(this).attr("data-link");
		AJS.$(this).wrap("<a href='" + link + "'></a>");
	});
	
	//Faq items
	AJS.$(".am-faq-button").click(function(){
		let macroId = AJS.$(this).attr("data-macro-id");
		let faqId = AJS.$(this).attr("data-faq-id");
		
		AJS.$(".am-faq-button[data-faq-id='" + faqId + "']").removeClass("is-active");		
		AJS.$(".am-faq-button[data-faq-id='" + faqId + "']").removeClass("am-faq-item-selected");		
		AJS.$(this).addClass("is-active");
		AJS.$(this).addClass("am-faq-item-selected");
		
		AJS.$(".macro-items[data-faq-id='" + faqId + "'] > article").hide();
		AJS.$(".am-faq-item[data-macro-id='" + macroId + "']").show();
	});

	//Show first faq
	AJS.$(".am-faq-container").each(function(){
		if (AJS.$(this).attr("data-faq-autodisplay") == "true"){
			AJS.$(this).find(".am-faq-button")[0].click();
		}
	});
	
	// Tabs Switching
	AJS.$('.tab').click(function() {		
		var tabMacroId = $(this).data("macro-id");
		
		// Remove current displayed content and inactive previous tab
		AJS.$(this).siblings().removeClass('is-active');
		AJS.$('.tab-content[data-macro-id="'+tabMacroId+'"]').siblings().hide();
		
		// Active current tab and related content
		
		AJS.$(this).addClass('is-active');
		AJS.$('.tab-content[data-macro-id="'+tabMacroId+'"]').show();
	});
	
	//Initialize Accordions
	var accordions = bulmaAccordion.attach();
	

	//Animation images with wait option -- this pauses the animation until you can see the object
	let observer = new IntersectionObserver((entries, observer) => { 
		entries.forEach(entry => {
		if(entry.isIntersecting){
			let animation = entry.target.getAttribute("data-animation");
			entry.target.classList.remove("am-scroll-show");
			entry.target.classList.add("animated");
			entry.target.classList.add(animation);
		}
		});
	}, {rootMargin: "0px 0px -1px 0px"})

	document.querySelectorAll('.am-scroll-show').forEach(img => { observer.observe(img) });
	
    // Countdown
    AJS.$('.am-countdown').each(function() {
        
        let endDate = AJS.$(this).data("end-date");
        console.log("End date", endDate);
        AJS.$(this).countdown(endDate)
            .on('update.countdown', function(event) {
            	AJS.$(this).html(event.strftime('<span class="b4c"><span class="tag is-info is-large">%D days</span> <span class="tag is-info is-large">%H hours</span> <span class="tag is-info is-large">%M minutes</span> <span class="tag is-info is-large">%S seconds</span></span>'));
            }).on('finish.countdown',  function(event) {
            	AJS.$(this).hide();
                let target = AJS.$(this).attr('for');
                AJS.$('#'+target).show();
            });
    });
    
    //Image reveal title
    AJS.$('.am-image-reveal').mouseenter(function(){
    	let macroId = AJS.$(this).attr("data-macro-id");
    	AJS.$(".am-image-title-container[data-macro-id='" + macroId + "'").removeClass("fadeIn fadeOut animated");
    	AJS.$(".am-image-title-container[data-macro-id='" + macroId + "'").addClass("fadeIn animated");
    }).mouseleave(function(){
    	let macroId = AJS.$(this).attr("data-macro-id");
    	AJS.$(".am-image-title-container[data-macro-id='" + macroId + "'").removeClass("fadeIn fadeOut animated");
    	AJS.$(".am-image-title-container[data-macro-id='" + macroId + "'").addClass("fadeOut animated");
    });
    
    
    //Show toasts
    AJS.$(".am-toast").each(function(){
    	let style = AJS.$(this).attr("data-style");
    	let position = AJS.$(this).attr("data-position");
    	let closeable = AJS.$(this).attr("data-closeable");
    	let body = AJS.$(this).html();
    	bulmaToast.toast({ message: body, type: style, dismissible: !!closeable, position: position, duration: 10000});
    });
    
    //Implements add/remove space favourite 
	AJS.$(".am-fav-space").click(function(e){
	 	e.preventDefault();
	 	var spaceKey = AJS.$(this).attr("data-space");
	 	var data = {
                        "key": spaceKey
                    };
	 	AJS.$.ajax({
	    	type: "POST",
	    	url: AJS.params.baseUrl + "/rest/dazzle/1.0/space/favourite",
			cache: false,
			data : JSON.stringify(data),
			contentType : "application/json;  charset=utf-8",
			dataType : "json"
	    }).done(function(c){
	    	AJS.$(".am-fav-space[data-space='" + spaceKey + "']").addClass("hidden");
	    	AJS.$(".am-unfav-space[data-space='" + spaceKey + "']").removeClass("hidden");
		})
	});
		
	AJS.$(".am-unfav-space").click(function(e){
		e.preventDefault();
	 	var spaceKey = AJS.$(this).attr("data-space");
	 	AJS.$.ajax({
	    	type: "DELETE",
	    	url: AJS.params.baseUrl + "/rest/dazzle/1.0/space/favourite?key=" + spaceKey,
			cache: false,
			contentType : "application/json;  charset=utf-8",
			dataType : "json"
	    }).done(function(c){
	    	AJS.$(".am-fav-space[data-space='" + spaceKey + "']").removeClass("hidden");
	    	AJS.$(".am-unfav-space[data-space='" + spaceKey + "']").addClass("hidden");
		})
	});
	
	
});