AJS.$(document).ready(function() {
	AJS.$(".am-card-container-searcher").keyup(amdebounce(function(){
		let text = AJS.$(this).val().toLowerCase();
		AJS.$(this).parents(".am-card-container")
			.children(".am-card-container-cards").find(".is-parent").each(function(){
			console.log("labels", AJS.$(this).attr("data-tag"));
			if (AJS.$(this).attr("data-tag").toLowerCase().includes(text)){
				let card = AJS.$(this);
				card.removeClass("fadeInUp fadeOutDown animated am-hide");
				card.addClass("fadeInUp animated am-card-show");
			} else {
				let card = AJS.$(this);
				card.removeClass("fadeInUp fadeOutDown animated am-card-show");
				card.addClass("fadeOutDown animated am-card-hide");
			}
		});
		
	}, 500));
	
});

// Credit David Walsh (https://davidwalsh.name/javascript-debounce-function)

// Returns a function, that, as long as it continues to be invoked, will not
// be triggered. The function will be called after it stops being called for
// N milliseconds. If `immediate` is passed, trigger the function on the
// leading edge, instead of the trailing.
function amdebounce(func, wait, immediate) {
	var timeout;

	return function executedFunction() {
		var context = this;
		var args = arguments;

		var later = function() {
			timeout = null;
			if (!immediate)
				func.apply(context, args);
		};

		var callNow = immediate && !timeout;

		clearTimeout(timeout);

		timeout = setTimeout(later, wait);

		if (callNow)
			func.apply(context, args);
	};
}