/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.content;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.userstatus.FavouriteManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.component.vo.SpaceVO;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.StyleBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class SpaceList
extends DazzleMacro {
    private static final int MAX_LENGHT = 42;
    private final Logger log = Logger.getLogger(SpaceList.class);
    private static final String STYLE = "style";
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ConfluenceImport
    private PageManager pageManager;
    @ConfluenceImport
    private AttachmentManager attachmentManager;
    @ConfluenceImport
    private SettingsManager settingsManager;
    @ConfluenceImport
    private SpaceManager spaceManager;
    @ConfluenceImport
    private SpacePermissionManager spacePermissionManager;
    @ConfluenceImport
    private FavouriteManager favouriteManager;

    @Autowired
    public SpaceList(DazzleLicenseService dazzleLicenseService, PageBuilderService pageBuilderService, PageManager pageManager, AttachmentManager attachmentManager, SettingsManager settingsManager, SpaceManager spaceManager, FavouriteManager favouriteManager, SpacePermissionManager spacePermissionManager) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.settingsManager = settingsManager;
        this.spaceManager = spaceManager;
        this.favouriteManager = favouriteManager;
        this.spacePermissionManager = spacePermissionManager;
    }

    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma");
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        List<SpaceVO> spaces = this.getSpaces();
        contextParams.put("columns", this.getSpacesInColumns(spaces, Integer.valueOf(parameters.getOrDefault("numCols", "2"))));
        contextParams.put("columnClass", this.getColumnClass(parameters.getOrDefault("numCols", "2")));
        contextParams.put("baseUrl", this.settingsManager.getGlobalSettings().getBaseUrl());
        contextParams.put(STYLE, new StyleBuilder().addStyle("background-color", this.getMainColor(parameters.get("backgroundColor"))).build());
        contextParams.putAll(parameters);
        String templatePath = "templates/space-list.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, contextParams);
    }

    private String getColumnClass(String column) {
        if ("1".equals(column)) {
            return "is-full";
        }
        if ("2".equals(column)) {
            return "is-half";
        }
        return "is-one-third";
    }

    private List<List<SpaceVO>> getSpacesInColumns(List<SpaceVO> spaces, int numColumns) {
        ArrayList<List<SpaceVO>> columns = new ArrayList<List<SpaceVO>>();
        for (int i = 0; i < numColumns; ++i) {
            columns.add(this.getSpacesCol(spaces, i, numColumns));
        }
        return columns;
    }

    private List<SpaceVO> getSpacesCol(List<SpaceVO> spaces, int col, int numCols) {
        ArrayList<SpaceVO> spacesCol = new ArrayList<SpaceVO>();
        for (int i = 0; i < spaces.size(); ++i) {
            if (i % numCols != col) continue;
            spacesCol.add(spaces.get(i));
        }
        return spacesCol;
    }

    private String getMainColor(String color) {
        if ("white".equals(color)) {
            return "fff";
        }
        if ("gray".equals(color)) {
            return "#f5f5f5";
        }
        if ("dark gray".equals(color)) {
            return "#dbdbdb";
        }
        return null;
    }

    private List<SpaceVO> getSpaces() {
        ArrayList<SpaceVO> spaces = new ArrayList<SpaceVO>();
        SpacesQuery.Builder queryBuilder = SpacesQuery.newQuery().withSpaceStatus(SpaceStatus.CURRENT);
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            SpacesQuery query = queryBuilder.forUser((User)user).build();
            this.getSpacesForUser(spaces, user, query);
        } else {
            SpacesQuery query = queryBuilder.build();
            this.getAnonymousSpaces(spaces, query);
        }
        return spaces;
    }

    private void getAnonymousSpaces(List<SpaceVO> spaces, SpacesQuery query) {
        for (Space space : this.spaceManager.getAllSpaces(query)) {
            if (!space.isIndexable() || space.isPersonal() || !space.isGlobal() || !this.spacePermissionManager.hasPermission("VIEWSPACE", space, null)) continue;
            SpaceVO vo = this.createSpaceVO(space, false);
            vo.setAnonymous(true);
            spaces.add(vo);
        }
    }

    private SpaceVO createSpaceVO(Space space, boolean faved) {
        SpaceVO vo = new SpaceVO();
        vo.setName(this.getMaxTitle(space.getDisplayTitle()));
        vo.setKey(space.getKey());
        vo.setIconUrl(this.spaceManager.getLogoForSpace(space.getKey()).getDownloadPath());
        vo.setFavedByUser(faved);
        vo.setSpaceUrl(this.settingsManager.getGlobalSettings().getBaseUrl() + space.getUrlPath());
        return vo;
    }

    private void getSpacesForUser(List<SpaceVO> spaces, ConfluenceUser user, SpacesQuery query) {
        for (Space space : this.spaceManager.getAllSpaces(query)) {
            if (!space.isIndexable() || space.isPersonal() || !space.isGlobal()) continue;
            SpaceVO vo = this.createSpaceVO(space, this.favouriteManager.isUserFavourite((User)user, space));
            spaces.add(vo);
        }
    }

    private String getMaxTitle(String title) {
        if (title.length() > 42) {
            return title.substring(0, 42) + "...";
        }
        return title;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

