/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.content;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.component.vo.AttachmentVO;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.MacroHelper;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class AttachmentTable
extends DazzleMacro {
    private final Logger log = Logger.getLogger(AttachmentTable.class);
    private static final int MAX_SEARCH_RESULTS = 1000;
    @ComponentImport
    private final AttachmentManager attachmentManager;
    @ComponentImport
    private final SettingsManager settingsManager;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ComponentImport
    private final CQLSearchService cQLSearchService;
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd hh:mm");

    @Autowired
    public AttachmentTable(DazzleLicenseService dazzleLicenseService, AttachmentManager attachmentManager, SettingsManager settingsManager, PageManager pageManager, SpaceManager spaceManager, PageBuilderService pageBuilderService, CQLSearchService cQLSearchService) {
        super(dazzleLicenseService);
        this.attachmentManager = attachmentManager;
        this.settingsManager = settingsManager;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.pageBuilderService = pageBuilderService;
        this.cQLSearchService = cQLSearchService;
    }

    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma").requireWebResource("com.atsistemas.confluence.app.awesome-macros:attachment-list");
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        String regex = parameters.get("filter");
        contextParams.put("attachments", this.getAttachments(parameters, conversionContext, regex));
        contextParams.putAll(parameters);
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        contextParams.put("macroId", macroDefinition.getMacroId().map(MacroId::getId).getOrNull());
        String templatePath = "templates/attachment-table.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, contextParams);
    }

    private Pattern getPattern(String regex) {
        try {
            if (StringUtils.isNotBlank((CharSequence)regex)) {
                return Pattern.compile(regex);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error compiling pattern", (Throwable)e);
        }
        return null;
    }

    private List<AttachmentVO> getAttachments(Map<String, String> parameters, ConversionContext conversionContext, String filter) {
        List<Object> attachments = new ArrayList();
        Pattern pattern = this.getPattern(filter);
        AbstractPage page = MacroHelper.getPageFromContext(this.pageManager, conversionContext);
        if ("page".equals(parameters.get("location"))) {
            attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page).stream().filter(a -> this.textMatches(pattern, a.getFileName())).collect(Collectors.toList());
        } else {
            PageResponse results = this.cQLSearchService.searchContent("space = " + page.getSpaceKey(), SearchContext.builder().build(), (PageRequest)new SimplePageRequest(0, 1000), new Expansion[0]);
            for (Content c : results.getResults()) {
                if (!c.getType().equals((Object)ContentType.ATTACHMENT) || !this.textMatches(pattern, c.getTitle())) continue;
                attachments.add(this.attachmentManager.getAttachment(c.getId().asLong()));
            }
        }
        return attachments.stream().map(this::getAttachmentVO).collect(Collectors.toList());
    }

    private boolean textMatches(Pattern pattern, String text) {
        if (StringUtils.isNotBlank((CharSequence)text) && pattern != null) {
            Matcher matcher = pattern.matcher(text);
            return matcher.find();
        }
        return true;
    }

    private AttachmentVO getAttachmentVO(Attachment at) {
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        AttachmentVO vo = new AttachmentVO();
        if (at != null) {
            vo.setName(at.getFileName());
            vo.setAttachmentUrl(baseUrl + at.getUrlPath());
            vo.setCreated(SDF.format(at.getCreationDate()));
            vo.setUserName(at.getCreator().getName());
            vo.setUserDisplayName(at.getCreator().getFullName());
            vo.setUpdated(SDF.format(at.getLastModificationDate()));
            vo.setLabels(at.getLabels().stream().map(Label::getName).collect(Collectors.toList()));
            vo.setSize(at.getNiceFileSize());
            vo.setType(at.getNiceType());
            this.getMediaTypeData(at, vo);
            vo.setPage(at.getContainer().getTitle());
            vo.setPageUrl(baseUrl + at.getContainer().getUrlPath());
            vo.setContainerType(at.getContainer().getType());
        }
        return vo;
    }

    private void getMediaTypeData(Attachment at, AttachmentVO vo) {
        Attachment.Type type = Attachment.Type.getForMimeType((String)at.getMediaType(), (String)at.getFileExtension());
        if (type != null) {
            vo.setTypeIcon(type.name().toLowerCase());
            vo.setTypeName(type.getDescription());
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

