/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.MacroHelper;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class Video
extends DazzleMacro {
    private static final int OTHER = 0;
    private static final int VIMEO = 1;
    private static final int YOUTUBE = 2;
    private static final String NAME = "name";
    private static final String SOURCE = "source";
    private final Logger log = Logger.getLogger(Video.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ConfluenceImport
    private PageManager pageManager;
    @ConfluenceImport
    private AttachmentManager attachmentManager;
    @ConfluenceImport
    private SettingsManager settingsManager;

    @Autowired
    public Video(PageBuilderService pageBuilderService, PageManager pageManager, AttachmentManager attachmentManager, SettingsManager settingsManager, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.settingsManager = settingsManager;
    }

    public String execute(Map<String, String> parameters, String string, ConversionContext conversionContext) throws MacroExecutionException {
        String src;
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma");
        String templatePath = "templates/video.vm";
        int platform = this.getPlatform(parameters.get(SOURCE));
        if (platform == 2) {
            parameters.put("youtube", "true");
            src = this.getVideoSrcYoutube(parameters);
        } else if (platform == 1) {
            parameters.put("vimeo", "true");
            src = this.getVideoSrcVimeo(parameters);
        } else {
            src = this.getVideoSrc(parameters, MacroHelper.getPageFromContext(this.pageManager, conversionContext));
        }
        parameters.put("src", src);
        parameters.put("height", parameters.getOrDefault("height", "360px"));
        parameters.put("width", parameters.getOrDefault("width", "640px"));
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        if (macroDefinition.getMacroId().isDefined()) {
            parameters.put("macroId", ((MacroId)macroDefinition.getMacroId().get()).getId());
        }
        return VelocityUtils.getRenderedTemplate((String)templatePath, parameters);
    }

    private String getVideoSrcVimeo(Map<String, String> parameters) {
        try {
            URI uri = new URI(parameters.get(SOURCE));
            String videoId = uri.getPath();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{videoId})) {
                StringBuilder sb = new StringBuilder("https://player.vimeo.com/video").append(videoId);
                if (Boolean.parseBoolean(parameters.get("autoplay"))) {
                    sb.append("?autoplay=1");
                }
                return sb.toString();
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error decoding vimeo url", (Throwable)e);
        }
        return null;
    }

    private String getVideoSrcYoutube(Map<String, String> parameters) {
        List params = URLEncodedUtils.parse((String)parameters.get(SOURCE), (Charset)Charset.defaultCharset());
        String videoId = null;
        for (NameValuePair pair : params) {
            if (!"v".equals(pair.getName())) continue;
            videoId = pair.getValue();
        }
        StringBuilder sb = new StringBuilder("https://www.youtube.com/embed/").append(videoId).append("?&modestbranding=1");
        if (Boolean.parseBoolean(parameters.get("autoplay"))) {
            sb.append("&autoplay=1");
        }
        if (!Boolean.parseBoolean(parameters.get("controls"))) {
            sb.append("&controls=0");
        }
        if (!Boolean.parseBoolean(parameters.get("loop"))) {
            sb.append("&loop=1");
        }
        return sb.toString();
    }

    private int getPlatform(String source) {
        if (StringUtils.isNotBlank((CharSequence)source)) {
            try {
                URI url = new URI(source);
                if (url.getHost().contains("youtube.com")) {
                    return 2;
                }
                if (url.getHost().contains("vimeo.com")) {
                    return 1;
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Error reading host from video", (Throwable)e);
            }
        }
        return 0;
    }

    private String getVideoSrc(Map<String, String> parameters, AbstractPage page) {
        if (StringUtils.isNotBlank((CharSequence)parameters.get(SOURCE))) {
            return parameters.get(SOURCE);
        }
        if (StringUtils.isNotBlank((CharSequence)parameters.get(NAME)) && page != null) {
            String url = this.getAttachmentSource(page, parameters.get(NAME));
            return (String)StringUtils.defaultIfBlank((CharSequence)url, (CharSequence)"#");
        }
        return "#";
    }

    private String getAttachmentSource(AbstractPage page, String attachmentName) {
        Attachment at = this.attachmentManager.getAttachment((ContentEntityObject)page, attachmentName);
        if (at != null) {
            return this.settingsManager.getGlobalSettings().getBaseUrl() + at.getDownloadPathWithoutVersionOrApiRevision();
        }
        return null;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

