/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.MacroHelper;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class PageBackground
extends DazzleMacro {
    private final Logger log = Logger.getLogger(PageBackground.class);
    private static final String NAME = "name";
    private static final String IMAGE = "image";
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ConfluenceImport
    private PageManager pageManager;
    @ConfluenceImport
    private AttachmentManager attachmentManager;
    @ConfluenceImport
    private SettingsManager settingsManager;

    @Autowired
    public PageBackground(PageBuilderService pageBuilderService, PageManager pageManager, AttachmentManager attachmentManager, SettingsManager settingsManager, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.settingsManager = settingsManager;
    }

    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        parameters.put("body", body);
        parameters.put("mainColor", this.getMainColor(parameters.get("backgroundColor")));
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:page-background");
        String src = this.getImageUrl(parameters, MacroHelper.getPageFromContext(this.pageManager, conversionContext));
        parameters.put(IMAGE, src);
        String templatePath = "templates/page-background.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, parameters);
    }

    private String getMainColor(String color) {
        if ("white solid".equals(color)) {
            return "fff";
        }
        if ("white transparent".equals(color)) {
            return "rgb(255, 255, 255, 0.7)";
        }
        if ("black solid".equals(color)) {
            return "000";
        }
        if ("black transparent".equals(color)) {
            return "rgb(0, 0, 0, 0.7)";
        }
        return null;
    }

    private String getImageUrl(Map<String, String> parameters, AbstractPage page) {
        if (StringUtils.isNotBlank((CharSequence)parameters.get(IMAGE))) {
            return parameters.get(IMAGE);
        }
        if (StringUtils.isNotBlank((CharSequence)parameters.get(NAME)) && page != null) {
            return this.getAttachmentSource(page, parameters.get(NAME));
        }
        return null;
    }

    private String getAttachmentSource(AbstractPage page, String attachmentName) {
        Attachment at = this.attachmentManager.getAttachment((ContentEntityObject)page, attachmentName);
        if (at != null) {
            return this.settingsManager.getGlobalSettings().getBaseUrl() + at.getDownloadPathWithoutVersionOrApiRevision();
        }
        return null;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

