/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.DefaultImageUtils;
import com.atsistemas.confluence.app.utils.MediaSourceExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class ImageGallery
extends DazzleMacro {
    private final Logger log = Logger.getLogger(ImageGallery.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ConfluenceComponent
    private final SettingsManager settingsManager;

    @Autowired
    public ImageGallery(PageBuilderService pageBuilderService, SettingsManager settingsManager, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.settingsManager = settingsManager;
    }

    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:lightbox").requireWebResource("com.atsistemas.confluence.app.awesome-macros:animate").requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma").requireWebResource("com.atsistemas.confluence.app.awesome-macros:font-awesome");
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        contextParams.putAll(parameters);
        contextParams.put("columns", this.getColumns(body, this.getNumColums(parameters), StringUtils.defaultString((String)parameters.get("animation"), (String)"none"), parameters.get("fixedHeight")));
        contextParams.put("scrExtractor", new MediaSourceExtractor());
        String templatePath = "templates/image-gallery.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, contextParams);
    }

    private int getNumColums(Map<String, String> parameters) {
        if (parameters.containsKey("numColumns")) {
            return Integer.valueOf(parameters.get("numColumns"));
        }
        return 3;
    }

    private List<List<String>> getColumns(String body, int numColums, String animation, String height) {
        ArrayList<List<String>> columns = new ArrayList<List<String>>();
        for (int i = 0; i < numColums; ++i) {
            columns.add(new ArrayList());
        }
        List<String> images = this.extractImages(body, animation, height);
        if (images.isEmpty()) {
            images = DefaultImageUtils.getDefaultImages(animation, height, this.settingsManager, 20);
        }
        for (int i = 0; i < images.size(); ++i) {
            ((List)columns.get(i % numColums)).add(images.get(i));
        }
        return columns;
    }

    private List<String> extractImages(String body, String animation, String height) {
        ArrayList<String> images = new ArrayList<String>();
        if (body != null) {
            Document document = Jsoup.parse((String)body);
            Elements buttons = document.getElementsByClass("am-media-container");
            for (Element e : buttons) {
                e.addClass("am-gallery-item-" + animation);
                if (StringUtils.isNotBlank((CharSequence)height)) {
                    Element img = e.getElementsByTag("img").first();
                    img.attr("style", "width:auto;height:" + height);
                }
                images.add(e.outerHtml());
            }
        }
        return images;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

