/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class Icon
extends DazzleMacro {
    private static final String SIZE = "size";
    private static final String FONT_SIZE = "fontSize";
    private final Logger log = Logger.getLogger(Icon.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;

    @Autowired
    public Icon(PageBuilderService pageBuilderService, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
    }

    public String execute(Map<String, String> parameters, String string, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma").requireWebResource("com.atsistemas.confluence.app.awesome-macros:font-awesome");
        this.getSizeParameters(parameters);
        String templatePath = "templates/icon.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, parameters);
    }

    private void getSizeParameters(Map<String, String> parameters) {
        String size = parameters.get(SIZE);
        if ("small".equals(size) || StringUtils.isBlank((CharSequence)size)) {
            parameters.put(SIZE, "height:1rem; width: 1rem;");
            parameters.put(FONT_SIZE, "font-size:1em;");
        } else if ("medium".equals(size)) {
            parameters.put(SIZE, "height:2rem; width: 2rem");
            parameters.put(FONT_SIZE, "font-size:2em;");
        } else if ("big".equals(size)) {
            parameters.put(SIZE, "height:4rem; width: 4rem");
            parameters.put(FONT_SIZE, "font-size:4em;");
        } else if ("bigger".equals(size)) {
            parameters.put(SIZE, "height:8rem; width: 8rem");
            parameters.put(FONT_SIZE, "font-size:8em;");
        } else if ("biggest".equals(size)) {
            parameters.put(SIZE, "height:16rem; width: 16rem");
            parameters.put(FONT_SIZE, "font-size:16em;");
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

