/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class FlipCard
extends DazzleMacro {
    private final Logger log = Logger.getLogger(FlipCard.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;

    @Autowired
    public FlipCard(PageBuilderService pageBuilderService, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
    }

    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:flipcard");
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        List<String> sides = this.getCardSides(body);
        if (sides.size() > 1) {
            contextParams.put("panelFrontHtml", sides.get(0));
            contextParams.put("panelBackHtml", sides.get(1));
        }
        contextParams.put("height", parameters.getOrDefault("height", "400px"));
        contextParams.put("width", parameters.getOrDefault("width", "300px"));
        contextParams.put("front-color", parameters.getOrDefault("front-color", "#000"));
        contextParams.put("back-color", parameters.getOrDefault("back-color", "#008080"));
        contextParams.put("onClick", Boolean.parseBoolean(parameters.getOrDefault("onClick", "false")));
        String templatePath = "templates/flip-card.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, contextParams);
    }

    private List<String> getCardSides(String body) {
        ArrayList<String> sides = new ArrayList<String>();
        if (body != null) {
            Document document = Jsoup.parse((String)body);
            Elements content = document.getElementsByClass("am-flip-card-content");
            for (Element e : content) {
                sides.add(e.outerHtml());
            }
        }
        return sides;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

