/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.StyleBuilder;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class Divider
extends DazzleMacro {
    private static final String SIZE = "size";
    private static final String FONT_SIZE = "font-size";
    private final Logger log = Logger.getLogger(Divider.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;

    @Autowired
    public Divider(PageBuilderService pageBuilderService, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
    }

    public String execute(Map<String, String> parameters, String string, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma").requireWebResource("com.atsistemas.confluence.app.awesome-macros:font-awesome").requireWebResource("com.atsistemas.confluence.app.awesome-macros:divider");
        String templatePath = "templates/divider.vm";
        parameters.put("divstyle", this.getStyle(parameters));
        parameters.put("iconStyle", this.getIconStyle(parameters));
        return VelocityUtils.getRenderedTemplate((String)templatePath, parameters);
    }

    private String getStyle(Map<String, String> parameters) {
        StyleBuilder sb = new StyleBuilder();
        if (parameters.get("isVertical") != null) {
            sb.addStyle("height", "100%");
        }
        if ("is-small".equals(parameters.get(SIZE))) {
            sb.addStyle(FONT_SIZE, "1.5em;");
        } else if ("is-medium".equals(parameters.get(SIZE))) {
            sb.addStyle(FONT_SIZE, "4em;");
        } else if ("is-large".equals(parameters.get(SIZE))) {
            sb.addStyle(FONT_SIZE, "8em;");
        }
        return sb.build();
    }

    private String getIconStyle(Map<String, String> parameters) {
        StyleBuilder sb = new StyleBuilder();
        sb.addStyle(FONT_SIZE, "inherit");
        String padding = parameters.get("isVertical") != null ? "padding-top" : "Padding-bottom";
        if ("is-medium".equals(parameters.get(SIZE))) {
            sb.addStyle(padding, "5vh");
        } else if ("is-large".equals(parameters.get(SIZE))) {
            sb.addStyle(padding, "11vh");
        }
        return sb.build();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

