/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.StyleBuilder;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class ColumnsContainer
extends DazzleMacro {
    private static final Logger log = Logger.getLogger(ColumnsContainer.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;

    @Autowired
    public ColumnsContainer(PageBuilderService pageBuilderService, @ConfluenceComponent DazzleLicenseService dazzleLicenseService) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma");
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("body", body);
        contextMap.put("style", this.getStyle(parameters));
        String templatePath = "templates/columns-container.vm";
        contextMap.put("verticalAlign", "true".equals(parameters.getOrDefault("verticalAlign", "false")));
        return VelocityUtils.getRenderedTemplate((String)templatePath, contextMap);
    }

    private String getStyle(Map<String, String> parameters) {
        String style = parameters.getOrDefault("style", "");
        if (parameters.get("showOverflow") != null) {
            StyleBuilder sb = new StyleBuilder();
            sb.addStyle("overflow-x", "auto");
            return sb.build() + style;
        }
        return style;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

