/*
 * Decompiled with CFR 0.152.
 */
package com.atsistemas.confluence.app.awesomemacros.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atsistemas.confluence.app.awesomemacros.component.DazzleMacro;
import com.atsistemas.confluence.app.awesomemacros.component.vo.LinkItemVO;
import com.atsistemas.confluence.app.awesomemacros.license.DazzleLicenseService;
import com.atsistemas.confluence.app.utils.BaseURLUpdater;
import com.atsistemas.confluence.app.utils.MacroHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class CardHeader
extends DazzleMacro {
    private static final String ICON_LINK = "iconLink";
    private static final String TAG_LIST = "tagList";
    private static final String HAS_FOOTER = "hasFooter";
    private static final String RIGHT_URL = "right_url";
    private static final String LEFT_URL = "left_url";
    private static final Logger log = Logger.getLogger(CardHeader.class);
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final SettingsManager settingsManager;

    @Autowired
    public CardHeader(PageBuilderService pageBuilderService, DazzleLicenseService dazzleLicenseService, PageManager pageManager, SpaceManager spaceManager, SettingsManager settingsManager) {
        super(dazzleLicenseService);
        this.pageBuilderService = pageBuilderService;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.settingsManager = settingsManager;
    }

    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.dazzleLicenseService.isAddonLicensed()) {
            return VelocityUtils.getRenderedTemplate((String)"templates/dazzle-no-licensed.vm", parameters);
        }
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        this.pageBuilderService.assembler().resources().requireWebResource("com.atsistemas.confluence.app.awesome-macros:bulma").requireWebResource("com.atsistemas.confluence.app.awesome-macros:font-awesome").requireWebResource("com.atsistemas.confluence.app.awesome-macros:cards");
        parameters.put("body", body);
        if (macroDefinition.getMacroId().isDefined()) {
            parameters.put("macroId", ((MacroId)macroDefinition.getMacroId().get()).getId());
        }
        parameters.put("space", conversionContext.getPageContext().getSpaceKey());
        String templatePath = "templates/card-header.vm";
        return VelocityUtils.getRenderedTemplate((String)templatePath, this.getTemplateContext(parameters));
    }

    private List<String> getTagList(String tags) {
        if (StringUtils.isNotBlank((CharSequence)tags)) {
            return Arrays.asList(tags.split("\\s"));
        }
        return new ArrayList<String>();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private LinkItemVO getLink(String url, String page, String space, String baseUrl) {
        LinkItemVO vo = new LinkItemVO();
        vo.setFullPage(page);
        vo.setLink(BaseURLUpdater.getUrl(url, this.settingsManager));
        vo.setPageTitle(MacroHelper.getPageFromParams(page));
        vo.setSpace(StringUtils.defaultString((String)MacroHelper.getSpaceFromParams(page), (String)space));
        vo.setConfluenceBaseUrl(baseUrl);
        vo.setPageUrl(this.getPageUrl(vo.getSpace(), vo.getPageTitle()));
        return vo;
    }

    private Map<String, Object> getTemplateContext(Map<String, String> parameters) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        LinkItemVO linkIcon = this.getLink(parameters.get("iconUrl"), parameters.get("page"), parameters.get("space"), baseUrl);
        LinkItemVO leftLink = this.getLink(parameters.get("leftLink"), parameters.get("lpage"), parameters.get("space"), baseUrl);
        LinkItemVO rightLink = this.getLink(parameters.get("rightLink"), parameters.get("rpage"), parameters.get("space"), baseUrl);
        context.put(HAS_FOOTER, parameters.get("leftButton") != null || parameters.get("rightButton") != null);
        context.put(TAG_LIST, this.getTagList(parameters.get("tags")));
        context.put(ICON_LINK, linkIcon.getUrlPrecedencePage());
        context.put(LEFT_URL, leftLink.getUrlPrecedencePage());
        context.put(RIGHT_URL, rightLink.getUrlPrecedencePage());
        context.putAll(parameters);
        return context;
    }

    private AbstractPage getContent(String space, String page) {
        if (page != null && space != null) {
            Space sp;
            Optional<BlogPost> blogpost;
            Page ab = this.pageManager.getPage(space, page);
            if (ab == null && (blogpost = this.pageManager.getBlogPosts(sp = this.spaceManager.getSpace(space), true).stream().filter(x -> page.equals(x.getTitle())).findFirst()).isPresent()) {
                ab = (AbstractPage)blogpost.get();
            }
            return ab;
        }
        return null;
    }

    private String getPageUrl(String space, String page) {
        try {
            AbstractPage ab = this.getContent(space, page);
            if (ab != null) {
                return ab.getUrlPath();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error obtaining page url", (Throwable)e);
        }
        return null;
    }
}

