--- SCRIPT TO GENERATE THE DROP SCRIPT OF ALL FOREIGN KEY CONSTRAINTS
DECLARE @ForeignKeyName    VARCHAR(4000)
DECLARE @ParentTableName   VARCHAR(4000)
DECLARE @ParentTableSchema VARCHAR(4000)

DECLARE @TSQLDropFK VARCHAR(max)

DECLARE CursorFK CURSOR FOR SELECT fk.name                  ForeignKeyName,
                                   schema_name(t.schema_id) ParentTableSchema,
                                   t.name                   ParentTableName
                            FROM sys.foreign_keys fk
                                     INNER JOIN sys.tables t on fk.parent_object_id = t.object_id
                            WHERE t.name LIKE 'MIG_%'
OPEN CursorFK
FETCH NEXT FROM CursorFK INTO @ForeignKeyName, @ParentTableSchema, @ParentTableName

WHILE (@@FETCH_STATUS = 0)
    BEGIN
        SET @TSQLDropFK = 'ALTER TABLE ' + quotename(@ParentTableSchema) + '.' + quotename(@ParentTableName) +
                          ' DROP CONSTRAINT ' + quotename(@ForeignKeyName) + ';'
        EXECUTE (@TSQLDropFK)
        FETCH NEXT FROM CursorFK INTO @ForeignKeyName, @ParentTableSchema, @ParentTableName
    END

CLOSE CursorFK
DEALLOCATE CursorFK
