/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app;

import com.atlassian.migration.app.AbstractMigrationListenerProxy;
import com.atlassian.migration.app.AbstractMigrationListenerProxyKt;
import com.atlassian.migration.app.AppDataDetails;
import com.atlassian.migration.app.BaseAppCloudMigrationListener;
import com.atlassian.migration.app.MigrationDetailsV1;
import com.atlassian.migration.app.PreloadHeartbeatHandler;
import com.atlassian.migration.app.ServerAppCustomField;
import com.atlassian.migration.app.UnknownProxyMethodException;
import com.atlassian.migration.app.confluence.ConfluenceAppCloudMigrationListenerV1;
import com.atlassian.migration.app.jira.JiraAppCloudMigrationListenerV1;
import com.atlassian.migration.app.preload.JiraProjectPreloadContext;
import com.atlassian.migration.app.preload.PreloadContext;
import com.atlassian.migration.app.preload.PreloadHeartbeat;
import com.atlassian.migration.app.preload.PreloadableApp;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ,\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0012\u001a\u00020\u00062\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u0006J\b\u0010\"\u001a\u0004\u0018\u00010#J\u0006\u0010$\u001a\u00020\u0010J\u0006\u0010%\u001a\u00020\u0010J\r\u0010&\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010'J\u001e\u0010(\u001a\u0004\u0018\u00010\u00042\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010*\u001a\u00020+H\u0004J\"\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/atlassian/migration/app/AbstractMigrationListenerProxy;", "Lcom/atlassian/migration/app/BaseAppCloudMigrationListener;", "Lcom/atlassian/migration/app/preload/PreloadableApp;", "service", "", "bundleKey", "", "log", "Lorg/slf4j/Logger;", "(Ljava/lang/Object;Ljava/lang/String;Lorg/slf4j/Logger;)V", "vendorClassLoader", "Ljava/lang/ClassLoader;", "kotlin.jvm.PlatformType", "vendorListenerImplClass", "Ljava/lang/Class;", "classImplementsSpecificListener", "", "clazz", "listenerClass", "checkedClasses", "", "getAppDataForPreload", "Ljava/util/stream/Stream;", "Lcom/atlassian/migration/app/AppDataDetails;", "preloadContext", "Lcom/atlassian/migration/app/preload/PreloadContext;", "preloadHeartbeat", "Ljava/util/Optional;", "Lcom/atlassian/migration/app/preload/PreloadHeartbeat;", "getConfluenceListener", "Lcom/atlassian/migration/app/confluence/ConfluenceAppCloudMigrationListenerV1;", "getForgeAppId", "Ljava/util/UUID;", "getForgeEnvironmentName", "getJiraListener", "Lcom/atlassian/migration/app/jira/JiraAppCloudMigrationListenerV1;", "isConnect", "isForge", "isPreloadSupported", "()Ljava/lang/Boolean;", "proxiedMigrationDetails", "vendorDetailsClass", "migrationDetails", "Lcom/atlassian/migration/app/MigrationDetailsV1;", "setField", "", "field", "Ljava/lang/reflect/Field;", "instance", "value", "Companion", "app-migration-assistant"})
public abstract class AbstractMigrationListenerProxy
implements BaseAppCloudMigrationListener,
PreloadableApp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object service;
    @NotNull
    private final String bundleKey;
    @NotNull
    private final Logger log;
    private final ClassLoader vendorClassLoader;
    @NotNull
    private final Class<Object> vendorListenerImplClass;
    @NotNull
    public static final String JIRA_LISTENER = "com.atlassian.migration.app.jira.JiraAppCloudMigrationListenerV1";
    @NotNull
    public static final String CONFLUENCE_LISTENER = "com.atlassian.migration.app.confluence.ConfluenceAppCloudMigrationListenerV1";
    @NotNull
    public static final String FORGE_LISTENER = "com.atlassian.migration.app.listener.DiscoverableForgeListener";
    @NotNull
    public static final String MULTI_TRANSFER_FORGE_LISTENER = "com.atlassian.migration.app.disco.MultiTransferDiscoverableForgeListener";
    @NotNull
    public static final String PRELOAD_LISTENER = "com.atlassian.migration.app.preload.PreloadableApp";

    public AbstractMigrationListenerProxy(@NotNull Object service, @NotNull String bundleKey, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)bundleKey, (String)"bundleKey");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.service = service;
        this.bundleKey = bundleKey;
        this.log = log;
        this.vendorClassLoader = this.service.getClass().getClassLoader();
        this.vendorListenerImplClass = this.service.getClass();
    }

    public final boolean isConnect() {
        return AbstractMigrationListenerProxyKt.methodOrNull(this.service.getClass(), (Function1<? super Method, Boolean>)((Function1)isConnect.1.INSTANCE)) != null;
    }

    @Nullable
    public final JiraAppCloudMigrationListenerV1 getJiraListener() {
        if (AbstractMigrationListenerProxy.classImplementsSpecificListener$default(this, this.service.getClass(), JIRA_LISTENER, null, 4, null)) {
            return new JiraAppCloudMigrationListenerV1(this){
                final /* synthetic */ AbstractMigrationListenerProxy this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public Map<String, String> getSupportedWorkflowRuleMappings() {
                    Object object = AbstractMigrationListenerProxy.access$getService$p(this.this$0).getClass().getMethod("getSupportedWorkflowRuleMappings", new Class[0]).invoke(AbstractMigrationListenerProxy.access$getService$p(this.this$0), new Object[0]);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                    return (Map)object;
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public Map<ServerAppCustomField, String> getSupportedCustomFieldMappings() {
                    void $this$mapTo$iv$iv;
                    Map mapFromVendor;
                    Object object = AbstractMigrationListenerProxy.access$getService$p(this.this$0).getClass().getMethod("getSupportedCustomFieldMappings", new Class[0]).invoke(AbstractMigrationListenerProxy.access$getService$p(this.this$0), new Object[0]);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.Any, kotlin.String>");
                    Map $this$map$iv = mapFromVendor = (Map)object;
                    boolean $i$f$map = false;
                    Map map = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void it;
                        Map.Entry<K, V> item$iv$iv;
                        Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(TuplesKt.to((Object)this.convertServerAppCustomField(it.getKey()), it.getValue()));
                    }
                    return MapsKt.toMap((Iterable)((List)destination$iv$iv));
                }

                private final ServerAppCustomField convertServerAppCustomField(Object key) {
                    return new ServerAppCustomField((String)key.getClass().getMethod("getFieldName", new Class[0]).invoke(key, new Object[0]), (String)key.getClass().getMethod("getFieldTypeKey", new Class[0]).invoke(key, new Object[0]));
                }
            };
        }
        return null;
    }

    @Nullable
    public final ConfluenceAppCloudMigrationListenerV1 getConfluenceListener() {
        if (AbstractMigrationListenerProxy.classImplementsSpecificListener$default(this, this.service.getClass(), CONFLUENCE_LISTENER, null, 4, null)) {
            return new ConfluenceAppCloudMigrationListenerV1(this){
                final /* synthetic */ AbstractMigrationListenerProxy this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public Map<String, String> getServerToForgeMacroMapping() {
                    Object object = AbstractMigrationListenerProxy.access$getService$p(this.this$0).getClass().getMethod("getServerToForgeMacroMapping", new Class[0]).invoke(AbstractMigrationListenerProxy.access$getService$p(this.this$0), new Object[0]);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                    return (Map)object;
                }
            };
        }
        return null;
    }

    @NotNull
    public final UUID getForgeAppId() {
        Object object = AbstractMigrationListenerProxyKt.methodOrThrow(this.service.getClass(), "getForgeAppId").invoke(this.service, new Object[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.UUID");
        return (UUID)object;
    }

    @NotNull
    public final String getForgeEnvironmentName() {
        String string;
        try {
            string = AbstractMigrationListenerProxyKt.methodOrThrow(this.service.getClass(), "getForgeEnvironmentName").invoke(this.service, new Object[0]).toString();
        }
        catch (Exception e) {
            string = AbstractMigrationListenerProxyKt.methodOrThrow(this.service.getClass(), "getForgeEnvironmentType").invoke(this.service, new Object[0]).toString();
        }
        return string;
    }

    @NotNull
    public Stream<AppDataDetails> getAppDataForPreload(@NotNull PreloadContext preloadContext, @NotNull Optional<PreloadHeartbeat> preloadHeartbeat) {
        Intrinsics.checkNotNullParameter((Object)preloadContext, (String)"preloadContext");
        Intrinsics.checkNotNullParameter(preloadHeartbeat, (String)"preloadHeartbeat");
        if (!this.isPreloadSupported().booleanValue()) {
            Stream<AppDataDetails> stream = Stream.empty();
            Intrinsics.checkNotNullExpressionValue(stream, (String)"empty()");
            return stream;
        }
        if (!(preloadContext instanceof JiraProjectPreloadContext)) {
            throw new IllegalStateException(("Unsupported preload context: " + preloadContext).toString());
        }
        Object[] objectArray = new Class[]{Long.TYPE};
        Constructor<?> constructor = this.vendorClassLoader.loadClass(JiraProjectPreloadContext.class.getName()).getConstructor((Class<?>[])objectArray);
        objectArray = new Object[]{((JiraProjectPreloadContext)preloadContext).getProjectId()};
        Object context = constructor.newInstance(objectArray);
        Class<?> vendorAppDataDetailsClass = this.vendorClassLoader.loadClass(AppDataDetails.class.getName());
        Intrinsics.checkNotNullExpressionValue(vendorAppDataDetailsClass, (String)"vendorAppDataDetailsClass");
        Method getPathMethod = AbstractMigrationListenerProxyKt.methodOrThrow(vendorAppDataDetailsClass, "getPath");
        Method getIdMethod = AbstractMigrationListenerProxyKt.methodOrThrow(vendorAppDataDetailsClass, "getId");
        Method getInfoMethod = AbstractMigrationListenerProxyKt.methodOrThrow(vendorAppDataDetailsClass, "getInfo");
        Method vendorGetAppDataForPreloadMethod = AbstractMigrationListenerProxyKt.methodOrThrow(this.vendorListenerImplClass, "getAppDataForPreload");
        Class<?> vendorPreloadHeartbeatClass = this.vendorClassLoader.loadClass(PreloadHeartbeat.class.getName());
        Optional<Object> preloadHeartbeatProxyOptional2 = preloadHeartbeat.map(arg_0 -> AbstractMigrationListenerProxy.getAppDataForPreload$lambda$0((Function1)new Function1<PreloadHeartbeat, Object>(vendorPreloadHeartbeatClass){
            final /* synthetic */ Class<?> $vendorPreloadHeartbeatClass;
            {
                this.$vendorPreloadHeartbeatClass = $vendorPreloadHeartbeatClass;
                super(1);
            }

            public final Object invoke(PreloadHeartbeat heartbeat) {
                ClassLoader classLoader = this.$vendorPreloadHeartbeatClass.getClassLoader();
                Class[] classArray = new Class[]{this.$vendorPreloadHeartbeatClass};
                Intrinsics.checkNotNullExpressionValue((Object)heartbeat, (String)"heartbeat");
                return Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new PreloadHeartbeatHandler(heartbeat));
            }
        }, arg_0));
        Object[] objectArray2 = new Object[]{context, preloadHeartbeatProxyOptional2};
        Object object = vendorGetAppDataForPreloadMethod.invoke(this.service, objectArray2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.stream.Stream<kotlin.Any>");
        Stream<AppDataDetails> stream = ((Stream)object).map(arg_0 -> AbstractMigrationListenerProxy.getAppDataForPreload$lambda$1(getIdMethod, getPathMethod, getInfoMethod, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"vendorGetAppDataForPrelo\u2026, info)\n                }");
        return stream;
    }

    @NotNull
    public Boolean isPreloadSupported() {
        boolean bl;
        try {
            boolean bl2;
            if (AbstractMigrationListenerProxy.classImplementsSpecificListener$default(this, this.service.getClass(), PRELOAD_LISTENER, null, 4, null)) {
                Method method2 = AbstractMigrationListenerProxyKt.methodOrNull(this.service.getClass(), (Function1<? super Method, Boolean>)((Function1)isPreloadSupported.1.INSTANCE));
                Boolean bl3 = (Boolean)(method2 != null ? method2.invoke(this.service, new Object[0]) : null);
                bl2 = bl3 != null ? bl3 : false;
            } else {
                GenericDeclaration genericDeclaration = AbstractMigrationListenerProxyKt.methodOrNull(this.service.getClass(), (Function1<? super Method, Boolean>)((Function1)isPreloadSupported.2.INSTANCE));
                bl2 = genericDeclaration != null && (genericDeclaration = ((Method)genericDeclaration).getDeclaringClass()) != null ? genericDeclaration.equals(this.service.getClass()) : false;
            }
            bl = bl2;
        }
        catch (NoSuchMethodException e) {
            bl = false;
        }
        catch (UnknownProxyMethodException e) {
            bl = false;
        }
        catch (Exception e) {
            this.log.warn("Error while checking if preload is supported for app with key " + this.bundleKey, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    public final boolean isForge() {
        return AbstractMigrationListenerProxy.classImplementsSpecificListener$default(this, this.service.getClass(), FORGE_LISTENER, null, 4, null) || AbstractMigrationListenerProxy.classImplementsSpecificListener$default(this, this.service.getClass(), MULTI_TRANSFER_FORGE_LISTENER, null, 4, null);
    }

    @Nullable
    protected final Object proxiedMigrationDetails(@NotNull Class<?> vendorDetailsClass, @NotNull MigrationDetailsV1 migrationDetails) {
        Intrinsics.checkNotNullParameter(vendorDetailsClass, (String)"vendorDetailsClass");
        Intrinsics.checkNotNullParameter((Object)migrationDetails, (String)"migrationDetails");
        Object newInstance = vendorDetailsClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Field field = vendorDetailsClass.getDeclaredField("migrationId");
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"vendorDetailsClass.getDeclaredField(\"migrationId\")");
        Intrinsics.checkNotNullExpressionValue(newInstance, (String)"newInstance");
        this.setField(field, newInstance, migrationDetails.getMigrationId());
        Field field2 = vendorDetailsClass.getDeclaredField("migrationScopeId");
        Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"vendorDetailsClass.getDe\u2026Field(\"migrationScopeId\")");
        this.setField(field2, newInstance, migrationDetails.getMigrationScopeId());
        Field field3 = vendorDetailsClass.getDeclaredField("name");
        Intrinsics.checkNotNullExpressionValue((Object)field3, (String)"vendorDetailsClass.getDeclaredField(\"name\")");
        this.setField(field3, newInstance, migrationDetails.getName());
        Field field4 = vendorDetailsClass.getDeclaredField("createdAt");
        Intrinsics.checkNotNullExpressionValue((Object)field4, (String)"vendorDetailsClass.getDeclaredField(\"createdAt\")");
        this.setField(field4, newInstance, migrationDetails.getCreatedAt());
        Field field5 = vendorDetailsClass.getDeclaredField("jiraClientKey");
        Intrinsics.checkNotNullExpressionValue((Object)field5, (String)"vendorDetailsClass.getDe\u2026redField(\"jiraClientKey\")");
        this.setField(field5, newInstance, migrationDetails.getJiraClientKey());
        Field field6 = vendorDetailsClass.getDeclaredField("confluenceClientKey");
        Intrinsics.checkNotNullExpressionValue((Object)field6, (String)"vendorDetailsClass.getDe\u2026ld(\"confluenceClientKey\")");
        this.setField(field6, newInstance, migrationDetails.getConfluenceClientKey());
        Field field7 = vendorDetailsClass.getDeclaredField("cloudUrl");
        Intrinsics.checkNotNullExpressionValue((Object)field7, (String)"vendorDetailsClass.getDeclaredField(\"cloudUrl\")");
        this.setField(field7, newInstance, migrationDetails.getCloudUrl());
        return newInstance;
    }

    private final void setField(Field field, Object instance, Object value) {
        field.setAccessible(true);
        field.set(instance, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean classImplementsSpecificListener(Class<?> clazz, String listenerClass, Set<String> checkedClasses) {
        Class it;
        String string = clazz.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.name");
        if (!checkedClasses.add(string)) return false;
        Class<?>[] classArray = clazz.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"clazz.interfaces");
        Object[] $this$any$iv = classArray;
        boolean $i$f$any = false;
        for (Object element$iv : $this$any$iv) {
            it = (Class)element$iv;
            boolean bl = false;
            if (!it.getName().equals(listenerClass)) continue;
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        Class<?>[] classArray2 = clazz.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray2, (String)"clazz.interfaces");
        $this$any$iv = classArray2;
        $i$f$any = false;
        for (Object element$iv : $this$any$iv) {
            it = (Class)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!this.classImplementsSpecificListener(it, listenerClass, checkedClasses)) continue;
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 == null) return false;
        Class<?> it2 = clazz2;
        boolean bl4 = false;
        boolean bl5 = this.classImplementsSpecificListener(it2, listenerClass, checkedClasses);
        if (!bl5) return false;
        return true;
    }

    static /* synthetic */ boolean classImplementsSpecificListener$default(AbstractMigrationListenerProxy abstractMigrationListenerProxy, Class clazz, String string, Set set, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: classImplementsSpecificListener");
        }
        if ((n & 4) != 0) {
            set = new HashSet();
        }
        return abstractMigrationListenerProxy.classImplementsSpecificListener(clazz, string, set);
    }

    private static final Object getAppDataForPreload$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final AppDataDetails getAppDataForPreload$lambda$1(Method $getIdMethod, Method $getPathMethod, Method $getInfoMethod, Object it) {
        Intrinsics.checkNotNullParameter((Object)$getIdMethod, (String)"$getIdMethod");
        Intrinsics.checkNotNullParameter((Object)$getPathMethod, (String)"$getPathMethod");
        Intrinsics.checkNotNullParameter((Object)$getInfoMethod, (String)"$getInfoMethod");
        Object object = $getIdMethod.invoke(it, new Object[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String id = (String)object;
        Object object2 = $getPathMethod.invoke(it, new Object[0]);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.nio.file.Path");
        Path path = (Path)object2;
        Object object3 = $getInfoMethod.invoke(it, new Object[0]);
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
        String info = (String)object3;
        return new AppDataDetails(id, path, info);
    }

    public static final /* synthetic */ Object access$getService$p(AbstractMigrationListenerProxy $this) {
        return $this.service;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/migration/app/AbstractMigrationListenerProxy$Companion;", "", "()V", "CONFLUENCE_LISTENER", "", "FORGE_LISTENER", "JIRA_LISTENER", "MULTI_TRANSFER_FORGE_LISTENER", "PRELOAD_LISTENER", "app-migration-assistant"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

