/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.worker;

import com.atlassian.migration.agent.entity.MigrateUsersTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.impl.StepSubType;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.user.UsersMigrationExecutor;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.ProgressUnit;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.UserUploadProcessor;
import com.atlassian.migration.agent.v4.tasks.TransferTaskType;
import com.atlassian.migration.agent.v4.tasks.UsersGroupsUploadTask;
import com.atlassian.migration.agent.v4.worker.V4Worker;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.CommandName;
import java.util.List;
import org.slf4j.Logger;

public class UsersGroupsUploadWorker
extends V4Worker<UsersGroupsUploadTask> {
    private static final Logger log = ContextLoggerFactory.getLogger(UsersGroupsUploadWorker.class);
    private UsersGroupsUploadTask task;
    private UsersMigrationExecutor usersMigrationExecutor;
    private final V4Logger v4Logger;
    private final ClusterInformationService clusterInformationService;

    public UsersGroupsUploadWorker(List<ProgressUnit> supportedUnits, PlanStore planStore, StepStore stepStore, PluginTransactionTemplate defaultPluginTransactionTemplate, TaskStore taskStore, UsersMigrationExecutor usersMigrationExecutor, MigrationLogService migrationLogService, V4Logger v4Logger, ClusterInformationService clusterInformationService) {
        super(supportedUnits, planStore, taskStore, stepStore, defaultPluginTransactionTemplate, migrationLogService);
        this.commandName = CommandName.ALL_USER_UPLOAD;
        this.usersMigrationExecutor = usersMigrationExecutor;
        this.v4Logger = v4Logger;
        this.clusterInformationService = clusterInformationService;
    }

    @Override
    public StepResult process(PrcTask<UsersGroupsUploadTask> prcTask, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler) {
        this.task = prcTask.getTransferTask();
        Step prcStep = this.translatePrcTaskAsStep(prcTask);
        prcStep.setType(StepType.USERS_MIGRATION.name());
        prcStep.setSubType(StepSubType.USERS_EXPORT.name());
        V4LogContext logContext = V4LogContext.builder().stepId(prcStep.getId()).prcTaskId(prcTask.getTransferTask().getTaskId()).nodeId(this.clusterInformationService.getCurrentNodeId()).nodeExecutionId(prcStep.getNodeExecutionId()).executionState(prcStep.getExecutionState()).build();
        this.getPtx().write(() -> this.getStepStore().update(prcStep));
        UserUploadProcessor processor = new UserUploadProcessor(prcTask, this.usersMigrationExecutor, prcPoller, pollerConfigHandler, prcStep, this.migrationLogService, this.v4Logger, this.clusterInformationService);
        this.v4Logger.logInfo(log, logContext, "Users migration upload process initiated for task");
        return processor.initiate();
    }

    @Override
    public TransferTaskType getTransferTaskType() {
        return TransferTaskType.ALL_USER_UPLOAD;
    }

    @Override
    public Task getMigTask(List<Task> tasks, PrcTask<UsersGroupsUploadTask> prcTask) {
        return tasks.stream().filter(MigrateUsersTask.class::isInstance).map(MigrateUsersTask.class::cast).findFirst().orElse(null);
    }

    @Override
    public void setStepConfig(Step step) {
    }
}

