/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.udc.async;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.udc.async.EventBus;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class CCMAEventBus
implements EventBus {
    private static final Logger log = ContextLoggerFactory.getLogger(CCMAEventBus.class);
    private final AnalyticsEventService analyticsEventService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public void post(@NotNull Object event) {
        if (this.migrationDarkFeaturesManager.enableExtraEvents()) {
            Optional<Supplier> eventSupplier = this.getAsOperationalEvent(event).map(method2 -> () -> {
                try {
                    return (EventDto)method2.invoke(event, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.warn("Failed to post analytics event", (Throwable)e);
                    return null;
                }
            });
            if (!eventSupplier.isPresent()) {
                log.debug("Cannot handle Event {}, ignoring", event);
                return;
            }
            eventSupplier.ifPresent(this::safelyPostAnalyticsEvent);
        } else if (event instanceof UserMappingEvent) {
            this.safelyPostAnalyticsEvent((UserMappingEvent)event);
        } else {
            log.debug("Cannot handle Event {}, ignoring", event);
        }
    }

    private Optional<Method> getAsOperationalEvent(@NotNull Object event) {
        try {
            Class<?> eventClass = event.getClass();
            return Optional.of(eventClass.getDeclaredMethod("asOperationalEvent", new Class[0])).filter(m -> {
                int modifiers = m.getModifiers();
                return Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers);
            }).filter(m -> EventDto.class.isAssignableFrom(m.getReturnType()));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    private void safelyPostAnalyticsEvent(UserMappingEvent event) {
        try {
            this.analyticsEventService.saveAnalyticsEventAsync(() -> ((UserMappingEvent)event).asOperationalEvent());
        }
        catch (Exception e) {
            log.warn("Failed to post analytics event", (Throwable)e);
        }
    }

    private void safelyPostAnalyticsEvent(Supplier<EventDto> eventSupplier) {
        try {
            this.analyticsEventService.saveAnalyticsEventAsync(eventSupplier);
        }
        catch (Exception e) {
            log.warn("Failed to post analytics event", (Throwable)e);
        }
    }

    @Generated
    public CCMAEventBus(AnalyticsEventService analyticsEventService, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.analyticsEventService = analyticsEventService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }
}

