/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.service.app.PluginManager;
import com.atlassian.migration.agent.service.guardrails.OutputFilenames;
import com.atlassian.migration.agent.service.guardrails.OutputPathGenerator;
import com.atlassian.migration.agent.service.guardrails.util.SerializationUtil;
import com.atlassian.migration.agent.service.guardrails.util.ZipBuilder;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.SeparateFileQuery;
import com.atlassian.migration.agent.store.guardrails.queries.AbstractSingletonQuery;
import com.atlassian.migration.agent.store.guardrails.results.JsonResult;
import com.atlassian.migration.app.AbstractCloudMigrationRegistrar;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserInstalledAppsQuery
extends AbstractSingletonQuery
implements SeparateFileQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserInstalledAppsQuery.class);
    private final PluginManager pluginManager;
    private final AbstractCloudMigrationRegistrar abstractCloudMigrationRegistrar;
    private final OutputPathGenerator outputPathGenerator;
    private static final AppDetails EXAMPLE = new AppDetails((List<PluginAssessmentDetails>)ImmutableList.of((Object)new PluginAssessmentDetails("com.atlassian.migration.agent", "Confluence Cloud Migration Assistant", "3.11.21", "NOT_FOUND", "atlassian", "atlassian.com"), (Object)new PluginAssessmentDetails("com.atlassian.support.achoo-database-console-plugin", "Achoo Database Console Plugin", "1.4.1", "NOT_FOUND", "atlassian", "atlassian.com")));

    public UserInstalledAppsQuery(PluginManager pluginManager, AbstractCloudMigrationRegistrar abstractCloudMigrationRegistrar, OutputPathGenerator outputPathGenerator) {
        super(QueryIds.USER_INSTALLED_APPS, new JsonResult(EXAMPLE));
        this.pluginManager = pluginManager;
        this.abstractCloudMigrationRegistrar = abstractCloudMigrationRegistrar;
        this.outputPathGenerator = outputPathGenerator;
    }

    @Override
    protected JsonResult execute() {
        return new JsonResult(this.getUserInstalledApps());
    }

    @Override
    public void addToZip(QueryIds id, String date, String serverId, String assessmentStartDate, String instanceTimezone, String response, ZipBuilder zipBuilder) throws IOException {
        ImmutableMap data = ImmutableMap.of((Object)"serverId", (Object)serverId, (Object)"assessmentStartingDate", (Object)assessmentStartDate, (Object)"appAssessment", (Object)new Gson().fromJson(response, AppDetails.class));
        zipBuilder.addJson(data, OutputFilenames.APPS.getFilename(date) + ".jsonl", "Apps");
    }

    @Override
    public Path createPath(String date, String serverId, String assessmentStartDate, String instanceTimezone) throws IOException {
        ImmutableMap data = ImmutableMap.of((Object)"serverId", (Object)serverId, (Object)"assessmentStartingDate", (Object)assessmentStartDate, (Object)"appAssessment", (Object)this.getUserInstalledApps());
        Path path = this.outputPathGenerator.jsonFilePath(OutputFilenames.APPS.getFilename(date));
        SerializationUtil.saveJson(path.toFile(), data);
        return path;
    }

    private AppDetails getUserInstalledApps() {
        return new AppDetails(this.pluginManager.getActualUserInstalledPluginsWithNoBlacklistCall().stream().map(p -> {
            String pluginKey = p.getKey();
            PluginInformation pluginInformation = Optional.ofNullable(this.pluginManager.getPlugin(pluginKey)).map(Plugin::getPluginInformation).orElse(null);
            return new PluginAssessmentDetails(pluginKey, p.getName(), this.getPluginVersion(pluginInformation), this.getListenerType(pluginKey), this.getVendorName(pluginInformation), this.getVendorUrl(pluginInformation));
        }).collect(Collectors.toList()));
    }

    private String getPluginVersion(PluginInformation pluginInformation) {
        return Optional.ofNullable(pluginInformation).map(PluginInformation::getVersion).orElse("0");
    }

    private String getVendorName(PluginInformation pluginInformation) {
        return Optional.ofNullable(pluginInformation).map(PluginInformation::getVendorName).orElse("");
    }

    private String getVendorUrl(PluginInformation pluginInformation) {
        return Optional.ofNullable(pluginInformation).map(PluginInformation::getVendorUrl).orElse("");
    }

    private String getListenerType(String pluginKey) {
        try {
            return this.abstractCloudMigrationRegistrar.getListenerMetadata(pluginKey).getListenerFamilyType().name();
        }
        catch (IllegalArgumentException e) {
            return "NOT_FOUND";
        }
    }

    public static class AppDetails {
        @org.codehaus.jackson.annotate.JsonProperty(value="APP_DETAILS")
        @JsonProperty(value="APP_DETAILS")
        private List<PluginAssessmentDetails> appDetails;

        @Generated
        public List<PluginAssessmentDetails> getAppDetails() {
            return this.appDetails;
        }

        @JsonProperty(value="APP_DETAILS")
        @Generated
        public void setAppDetails(List<PluginAssessmentDetails> appDetails) {
            this.appDetails = appDetails;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppDetails)) {
                return false;
            }
            AppDetails other = (AppDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<PluginAssessmentDetails> this$appDetails = this.getAppDetails();
            List<PluginAssessmentDetails> other$appDetails = other.getAppDetails();
            return !(this$appDetails == null ? other$appDetails != null : !((Object)this$appDetails).equals(other$appDetails));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AppDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<PluginAssessmentDetails> $appDetails = this.getAppDetails();
            result = result * 59 + ($appDetails == null ? 43 : ((Object)$appDetails).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UserInstalledAppsQuery.AppDetails(appDetails=" + this.getAppDetails() + ")";
        }

        @Generated
        public AppDetails(List<PluginAssessmentDetails> appDetails) {
            this.appDetails = appDetails;
        }

        @Generated
        public AppDetails() {
        }
    }

    public static class PluginAssessmentDetails {
        private String key;
        private String name;
        private String version;
        private String listenerType;
        private String vendorName;
        private String vendorUrl;

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getListenerType() {
            return this.listenerType;
        }

        @Generated
        public String getVendorName() {
            return this.vendorName;
        }

        @Generated
        public String getVendorUrl() {
            return this.vendorUrl;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public void setListenerType(String listenerType) {
            this.listenerType = listenerType;
        }

        @Generated
        public void setVendorName(String vendorName) {
            this.vendorName = vendorName;
        }

        @Generated
        public void setVendorUrl(String vendorUrl) {
            this.vendorUrl = vendorUrl;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PluginAssessmentDetails)) {
                return false;
            }
            PluginAssessmentDetails other = (PluginAssessmentDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$listenerType = this.getListenerType();
            String other$listenerType = other.getListenerType();
            if (this$listenerType == null ? other$listenerType != null : !this$listenerType.equals(other$listenerType)) {
                return false;
            }
            String this$vendorName = this.getVendorName();
            String other$vendorName = other.getVendorName();
            if (this$vendorName == null ? other$vendorName != null : !this$vendorName.equals(other$vendorName)) {
                return false;
            }
            String this$vendorUrl = this.getVendorUrl();
            String other$vendorUrl = other.getVendorUrl();
            return !(this$vendorUrl == null ? other$vendorUrl != null : !this$vendorUrl.equals(other$vendorUrl));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PluginAssessmentDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $listenerType = this.getListenerType();
            result = result * 59 + ($listenerType == null ? 43 : $listenerType.hashCode());
            String $vendorName = this.getVendorName();
            result = result * 59 + ($vendorName == null ? 43 : $vendorName.hashCode());
            String $vendorUrl = this.getVendorUrl();
            result = result * 59 + ($vendorUrl == null ? 43 : $vendorUrl.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UserInstalledAppsQuery.PluginAssessmentDetails(key=" + this.getKey() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", listenerType=" + this.getListenerType() + ", vendorName=" + this.getVendorName() + ", vendorUrl=" + this.getVendorUrl() + ")";
        }

        @Generated
        public PluginAssessmentDetails(String key, String name, String version, String listenerType, String vendorName, String vendorUrl) {
            this.key = key;
            this.name = name;
            this.version = version;
            this.listenerType = listenerType;
            this.vendorName = vendorName;
            this.vendorUrl = vendorUrl;
        }

        @Generated
        public PluginAssessmentDetails() {
        }
    }
}

