/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.GuardrailsFeatureFlagHelperService;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.AbstractQuery;
import com.atlassian.migration.agent.store.guardrails.results.JiraIssueMacroPerPageTopKQueryResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.Arrays;
import java.util.HashSet;

public class JiraIssueMacroPerPageQuery
extends AbstractQuery<JiraIssueMacroPerPageTopKQueryResult> {
    private final GuardrailsFeatureFlagHelperService guardrailsFeatureFlagHelperService;
    private static final String CONTENT_TYPE = "contentTypes";
    private static final String MACRO_PREFIX = "'macro-count.jira%'";

    public JiraIssueMacroPerPageQuery(EntityManagerTemplate tmpl, GuardrailsFeatureFlagHelperService guardrailsFeatureFlagHelperService) {
        super(QueryIds.JIRA_ISSUE_MACRO_TOP_100, tmpl, "select c.id as page_id, c.status as page_status, cp.name as content_property_name, cp.stringval as content_property_value from Content as c inner join ContentProperty as cp on c.id=cp.content.id where c.type in :contentTypes and c.status in ('current', 'draft') and c.previousVersion is null and cp.name like 'macro-count.jira%' and (c.version = 1 or cp.stringval like concat(cast(c.version - 1 as string), '-%'))", AbstractQuery.QueryBuilderOptions.param(CONTENT_TYPE, new HashSet<String>(Arrays.asList("PAGE", "BLOGPOST"))), new JiraIssueMacroPerPageTopKQueryResult(JiraIssueMacroPerPageQuery.example("page_id", "page_status", "content_property_name", "content_property_value").addRow(10354783L, "current", "macro-count.jira.key", "115").addRow(118358399L, "draft", "macro-count.jira", "86").build(), guardrailsFeatureFlagHelperService.recordsLimit()));
        this.guardrailsFeatureFlagHelperService = guardrailsFeatureFlagHelperService;
    }

    @Override
    public JiraIssueMacroPerPageTopKQueryResult execute() {
        return new JiraIssueMacroPerPageTopKQueryResult(this.listTuples(), this.guardrailsFeatureFlagHelperService.recordsLimit());
    }
}

