/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.Tracker;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.UploadDestinationType;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.ClusterLimits;
import com.atlassian.migration.agent.service.ExportDirManager;
import com.atlassian.migration.agent.service.MigrationErrorCode;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.ErrorEvent;
import com.atlassian.migration.agent.service.catalogue.MigrationCatalogueStorageService;
import com.atlassian.migration.agent.service.catalogue.model.MigrationCatalogueStorageFile;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.execution.SpaceBoundStepExecutor;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.shadowExecutor.ShadowMigrationExecutor;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepExecutionException;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceUploadProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.space.helper.SpaceImportConfigFileManager;
import com.atlassian.migration.agent.service.util.StopConditionCheckingUtil;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.MigrationProtocol;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.tasks.SpaceUploadTransferTask;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class SpaceUploadExecutor
implements SpaceBoundStepExecutor {
    @VisibleForTesting
    static final StepType UPLOAD_STEP_TYPE = StepType.DATA_UPLOAD;
    public static final String SUCCESS_STATUS_MESSAGE = "Data Upload Successful";
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceUploadExecutor.class);
    private static final int UPLOAD_WORK_THREAD_COUNT = 5;
    private static final String MIGRATION_ID = "migrationId";
    private static final String SPACE_KEY = "spaceKey";
    private static final String FILE_ID = "fileId";
    private final ProgressTracker progressTracker;
    private final ExportDirManager exportDirManager;
    private final StepStore stepStore;
    private final PluginTransactionTemplate ptx;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final MigrationCatalogueStorageService migrationCatalogueStorageService;
    private final SpaceManager spaceManager;
    private final SpaceImportConfigFileManager spaceImportConfigFileManager;
    private final ClusterLimits clusterLimits;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final ShadowMigrationExecutor shadowMigrationExecutor;
    private final V4Logger v4Logger;
    private final ClusterInformationService clusterInformationService;
    private final PlanStore planStore;

    public SpaceUploadExecutor(ProgressTracker progressTracker, ExportDirManager exportDirManager, StepStore stepStore, PluginTransactionTemplate ptx, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, MigrationCatalogueStorageService migrationCatalogueStorageService, SpaceManager spaceManager, SpaceImportConfigFileManager spaceImportConfigFileManager, ClusterLimits clusterLimits, MigrationDarkFeaturesManager migrationDarkFeaturesManager, ShadowMigrationExecutor shadowMigrationExecutor, V4Logger v4Logger, ClusterInformationService clusterInformationService, PlanStore planStore) {
        this(progressTracker, exportDirManager, stepStore, ptx, Instant::now, analyticsEventService, analyticsEventBuilder, migrationCatalogueStorageService, spaceManager, spaceImportConfigFileManager, clusterLimits, migrationDarkFeaturesManager, shadowMigrationExecutor, v4Logger, clusterInformationService, planStore);
    }

    @VisibleForTesting
    SpaceUploadExecutor(ProgressTracker progressTracker, ExportDirManager exportDirManager, StepStore stepStore, PluginTransactionTemplate ptx, Supplier<Instant> instantSupplier, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, MigrationCatalogueStorageService migrationCatalogueStorageService, SpaceManager spaceManager, SpaceImportConfigFileManager spaceImportConfigFileManager, ClusterLimits clusterLimits, MigrationDarkFeaturesManager migrationDarkFeaturesManager, ShadowMigrationExecutor shadowMigrationExecutor, V4Logger v4Logger, ClusterInformationService clusterInformationService, PlanStore planStore) {
        this.progressTracker = progressTracker;
        this.exportDirManager = exportDirManager;
        this.stepStore = stepStore;
        this.ptx = ptx;
        this.instantSupplier = instantSupplier;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.migrationCatalogueStorageService = migrationCatalogueStorageService;
        this.spaceManager = spaceManager;
        this.spaceImportConfigFileManager = spaceImportConfigFileManager;
        this.clusterLimits = clusterLimits;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.shadowMigrationExecutor = shadowMigrationExecutor;
        this.v4Logger = v4Logger;
        this.clusterInformationService = clusterInformationService;
        this.planStore = planStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    StepResult doSpaceUpload(String stepId, String fileId, String cloudId, String migrationId, String spaceKey, Optional<PrcTask> prcTask, Plan plan) {
        Object spaceId;
        if (prcTask.isPresent() && this.shadowMigrationExecutor.isShadowMigration(this.stepStore.getStep(stepId))) {
            return this.shadowMigrationExecutor.performShadowMigration(stepId, prcTask.get());
        }
        long startTime = this.instantSupplier.get().toEpochMilli();
        long freeHeapSizeAtStart = Runtime.getRuntime().freeMemory();
        long combinedUploadSize = this.exportDirManager.getExportSize(fileId);
        boolean success = false;
        this.sendstartedProgressUpdate(stepId, prcTask);
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        UploadDestinationType uploadType = UploadDestinationType.MCS;
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildSpaceUploadStartEvent(step, startTime, uploadType, fileId, spaceKey));
        V4LogContext logContext = V4LogContext.builder().stepId(stepId).stepType(step.getType()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties(MIGRATION_ID, migrationId, SPACE_KEY, spaceKey, FILE_ID, fileId);
        this.v4Logger.logInfo(log, logContext, String.format("Migration Space upload started with uploadType: %s", new Object[]{uploadType}));
        try {
            SpaceUploadProgressTracker spaceUploadProgressTracker = new SpaceUploadProgressTracker(uploadedBytes -> this.updateProgress(stepId, (Long)uploadedBytes, combinedUploadSize, spaceKey, prcTask));
            spaceId = String.valueOf(Objects.requireNonNull(this.spaceManager.getSpace(spaceKey)).getId());
            List<MigrationCatalogueStorageFile> uploadedFiles = this.uploadFilesToMCS(cloudId, migrationId, fileId, (String)spaceId, spaceKey, step, spaceUploadProgressTracker::addUploadedBytes);
            if (this.migrationDarkFeaturesManager.isReadingSpaceUploadFileConfigFromDBDisabled()) {
                this.spaceImportConfigFileManager.saveSpaceImportStepConfigToFile(migrationId, (String)spaceId, uploadedFiles);
                String stepConfigFileName = this.spaceImportConfigFileManager.getSpaceImportStepConfigFileName(migrationId, (String)spaceId);
                success = true;
                this.sendCompletionProgressUpdate(stepId, prcTask);
                prcTask.ifPresent(arg_0 -> this.lambda$doSpaceUpload$3(uploadedFiles, (String)spaceId, arg_0));
                HashMap<String, Object> resultProps = new HashMap<String, Object>();
                ArrayList<Object> spaceIds = new ArrayList<Object>();
                spaceIds.add(spaceId);
                resultProps.put("spaceIds", spaceIds);
                resultProps.put("dataExport", uploadedFiles);
                StepResult stepResult = StepResult.succeeded(SUCCESS_STATUS_MESSAGE, stepConfigFileName, resultProps);
                return stepResult;
            }
            String jsonAsString = Jsons.valueAsString(uploadedFiles);
            this.ptx.write(() -> {
                step.setStepMetadata(jsonAsString);
                this.stepStore.update(step);
            });
            success = true;
            this.sendCompletionProgressUpdate(stepId, prcTask);
            prcTask.ifPresent(arg_0 -> this.lambda$doSpaceUpload$5(uploadedFiles, (String)spaceId, arg_0));
            HashMap<String, Object> resultProps = new HashMap<String, Object>();
            ArrayList<Object> spaceIds = new ArrayList<Object>();
            spaceIds.add(spaceId);
            resultProps.put("spaceIds", spaceIds);
            resultProps.put("dataExport", uploadedFiles);
            StepResult stepResult = StepResult.succeeded(SUCCESS_STATUS_MESSAGE, SUCCESS_STATUS_MESSAGE, resultProps);
            return stepResult;
        }
        catch (UncheckedInterruptedException e) {
            this.v4Logger.logInfo(log, logContext, "Space Upload was stopped");
            this.sendSpaceUploadCancelledStatusToPrcIfV4Task(Optional.of(step), prcTask, "Data Upload Stopped");
            spaceId = StepResult.stopped();
            return spaceId;
        }
        catch (StepExecutionException e) {
            String response = ExceptionUtils.getThrowableList((Throwable)e).stream().filter(throwable -> {
                String message = throwable.getMessage();
                return StringUtils.isNotBlank((String)message) && !message.startsWith("java.lang.");
            }).findFirst().map(Throwable::getMessage).orElse(e.getMessage());
            String failureReason = "Failed to upload file with ID " + fileId;
            success = this.checkIfGoodEventAndLoggingAnalyticEvents(migrationId, cloudId, e.getErrorCode(), response, spaceKey, failureReason, uploadType);
            this.sendSpaceUploadFailureStatusToPrcIfV4Task(Optional.of(step), prcTask, e.getMessage());
            StepResult jsonAsString = StepResult.failed(failureReason, e);
            return jsonAsString;
        }
        catch (Exception e) {
            String failureReason = "Failed to upload file with ID " + fileId;
            success = this.checkIfGoodEventAndLoggingAnalyticEvents(migrationId, cloudId, MigrationErrorCode.SPACE_UPLOAD_FAILED, e.getMessage(), spaceKey, failureReason, uploadType);
            this.sendSpaceUploadFailureStatusToPrcIfV4Task(Optional.of(step), prcTask, e.getMessage());
            StepResult stepResult = StepResult.failed(failureReason, e);
            return stepResult;
        }
        finally {
            ImmutableMap additionalAttributes = ImmutableMap.of((Object)"stepSuccessful", (Object)String.valueOf(success), (Object)"uploadType", (Object)uploadType.name());
            this.analyticsEventService.saveAnalyticsEvents(() -> this.lambda$doSpaceUpload$8(step, (Map)additionalAttributes, freeHeapSizeAtStart, plan));
            this.saveStepTimerEvent(success, this.instantSupplier.get().toEpochMilli() - startTime, spaceKey, step, combinedUploadSize, uploadType);
        }
    }

    @VisibleForTesting
    synchronized void updateProgress(String stepId, Long uploadedBytes, long combinedUploadSize, String spaceKey, Optional<PrcTask> prcTask) {
        int percentageComplete = combinedUploadSize == 0L ? 100 : (int)(uploadedBytes * 100L / combinedUploadSize);
        String uploadedBytesStr = FileUtils.byteCountToDisplaySize((Number)uploadedBytes);
        String combinedUploadSizeStr = FileUtils.byteCountToDisplaySize((long)combinedUploadSize);
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties(SPACE_KEY, spaceKey);
        this.v4Logger.logInfo(log, logContext, String.format("Space Upload progress: %d%% complete (%s of %s uploaded)", percentageComplete, uploadedBytesStr, combinedUploadSizeStr));
        this.progressTracker.progress(stepId, percentageComplete, String.format("Uploaded %s of %s", uploadedBytesStr, combinedUploadSizeStr), StepType.DATA_UPLOAD.getDetailedStatus(), Collections.emptyMap(), prcTask);
    }

    synchronized void sendCompletionProgressUpdate(String stepId, Optional<PrcTask> prcTask) {
        this.progressTracker.progress(stepId, 100, "Upload complete", StepType.DATA_UPLOAD.getDetailedStatus(), Collections.emptyMap(), prcTask);
    }

    synchronized void sendstartedProgressUpdate(String stepId, Optional<PrcTask> prcTask) {
        this.progressTracker.progress(stepId, 0, "Upload started", StepType.DATA_UPLOAD.getDetailedStatus(), Collections.emptyMap(), prcTask);
    }

    private List<MigrationCatalogueStorageFile> uploadFilesToMCS(String cloudId, String migrationId, String fileId, String spaceId, String spaceKey, Step step, Tracker progressTracker) {
        Path exportFilePath = this.exportDirManager.getExportFilePath(fileId);
        ForkJoinPool customThreadPool = new ForkJoinPool(5);
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties(SPACE_KEY, spaceKey, FILE_ID, fileId, MIGRATION_ID, migrationId);
        try {
            List list = (List)((ForkJoinTask)customThreadPool.submit(() -> new ArrayList(FileUtils.listFiles((File)exportFilePath.toFile(), null, (boolean)false)).parallelStream().map(file -> this.upload(cloudId, migrationId, (File)file, spaceKey, step, spaceId, progressTracker)).collect(Collectors.toList()))).get();
            return list;
        }
        catch (InterruptedException | ExecutionException e) {
            if (StopConditionCheckingUtil.isStoppingExceptionInCausalChain(e)) {
                this.v4Logger.logWarn(log, logContext, String.format("File upload was stopped for plan: %s", step.getPlan().getId()));
                throw new UncheckedInterruptedException(e);
            }
            this.v4Logger.logError(log, logContext, "Error in uploading files to MCS", e);
            throw new StepExecutionException(MigrationErrorCode.MCS_API_ERROR, UPLOAD_STEP_TYPE, migrationId, e.getMessage(), e);
        }
        catch (Exception e) {
            this.v4Logger.logError(log, logContext, "Error in uploading files to MCS", e);
            throw new StepExecutionException(MigrationErrorCode.MCS_API_ERROR, UPLOAD_STEP_TYPE, migrationId, e.getMessage(), e);
        }
        finally {
            customThreadPool.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MigrationCatalogueStorageFile upload(String cloudId, String migrationId, File file, String spaceKey, Step step, String spaceId, Tracker progressTracker) {
        long startTime = this.instantSupplier.get().toEpochMilli();
        boolean success = false;
        try {
            MigrationCatalogueStorageFile fileUpload = this.migrationCatalogueStorageService.uploadFileToMCS(cloudId, migrationId, file.toPath(), spaceId, progressTracker);
            V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
            logContext.addAdditionalProperties(FILE_ID, fileUpload.getFileId(), SPACE_KEY, spaceKey);
            this.v4Logger.logInfo(log, logContext, String.format("File uploaded to MCS: %s (size: %d bytes) for space: %s", fileUpload.getName(), fileUpload.getSize(), spaceId));
            success = true;
            MigrationCatalogueStorageFile migrationCatalogueStorageFile = fileUpload;
            long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
            this.saveMCSFileUploadTimerEvent(success, timeTaken, spaceKey, step, file.canRead() ? file.length() : -1L, file.getName());
            return migrationCatalogueStorageFile;
        }
        catch (Throwable throwable) {
            long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
            this.saveMCSFileUploadTimerEvent(success, timeTaken, spaceKey, step, file.canRead() ? file.length() : -1L, file.getName());
            throw throwable;
        }
    }

    private void saveStepTimerEvent(boolean successful, long timeTaken, String spaceKey, Step step, long uploadSize, UploadDestinationType uploadType) {
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildSpaceUploadStepTimerEvent(successful, timeTaken, spaceKey, step, uploadSize, uploadType));
    }

    private void saveMCSFileUploadTimerEvent(boolean successful, long timeTaken, String spaceKey, Step step, long uploadSize, String filename) {
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildMCSFileUploadTimerEvent(successful, timeTaken, spaceKey, step, uploadSize, filename));
    }

    private boolean checkIfGoodEventAndLoggingAnalyticEvents(String migrationId, String cloudId, MigrationErrorCode errorCode, String response, String spaceKey, String failureReason, UploadDestinationType uploadType) {
        V4LogContext logContext = V4LogContext.builder().stepType(UPLOAD_STEP_TYPE.name()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties(MIGRATION_ID, migrationId, SPACE_KEY, spaceKey);
        this.v4Logger.logError(log, logContext, String.format("Migration Steptype: DATA_UPLOAD error - %s (ErrorCode: %s)", failureReason, errorCode.getCode()), null);
        return this.checkIfGoodEventAndSaveStepErrorAnalyticEvents(migrationId, cloudId, errorCode, response, spaceKey, uploadType);
    }

    private boolean checkIfGoodEventAndSaveStepErrorAnalyticEvents(String migrationId, String cloudId, MigrationErrorCode errorCode, String response, String spaceKey, UploadDestinationType uploadType) {
        boolean isSloGoodEvent = errorCode.shouldBeTreatedAsGoodEventInReliabilitySlo();
        ErrorEvent errorEvent = new ErrorEvent.ErrorEventBuilder(errorCode, errorCode.getContainerType(), migrationId, UPLOAD_STEP_TYPE).setCloudid(cloudId).setReason(response).setSpaceKey(spaceKey).build();
        this.analyticsEventService.sendAnalyticsEvents(() -> ImmutableList.of((Object)this.analyticsEventBuilder.buildFailedSpaceMigration(UPLOAD_STEP_TYPE, errorCode), (Object)this.analyticsEventBuilder.buildErrorOperationalEventForSpaceUpload(errorEvent, uploadType)));
        return isSloGoodEvent;
    }

    @Override
    public StepType getStepType() {
        return StepType.DATA_UPLOAD;
    }

    @Override
    public StepResult runStep(String stepId) {
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        Plan eagerPlan = this.planStore.getPlanWithTasksEagerly(step.getPlan().getId());
        String spaceKey = ((ConfluenceSpaceTask)step.getTask()).getSpaceKey();
        return this.wrapStepResultSupplier(this.analyticsEventBuilder, this.analyticsEventService, step, spaceKey, this.spaceManager, () -> this.doSpaceUpload(step.getId(), step.getConfig(), eagerPlan.getCloudSite().getCloudId(), eagerPlan.getMigrationId(), spaceKey, Optional.empty(), eagerPlan));
    }

    public StepResult runV4Step(String stepId, PrcTask<SpaceUploadTransferTask> prcTask) {
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        Plan eagerPlan = this.planStore.getPlanWithTasksEagerly(step.getPlan().getId());
        String spaceKey = ((ConfluenceSpaceTask)step.getTask()).getSpaceKey();
        return this.wrapStepResultSupplier(this.analyticsEventBuilder, this.analyticsEventService, step, spaceKey, this.spaceManager, () -> this.doSpaceUpload(step.getId(), step.getConfig(), eagerPlan.getCloudSite().getCloudId(), eagerPlan.getMigrationId(), spaceKey, Optional.of(prcTask), eagerPlan));
    }

    private void sendSpaceUploadFailureStatusToPrcIfV4Task(Optional<Step> step, Optional<PrcTask> prcTask, String statusMessage) {
        if (step.isPresent() && step.get().getPlan().getMigrationProtocol().equals((Object)MigrationProtocol.V4)) {
            if (prcTask.isPresent()) {
                this.progressTracker.sendV4SpaceUploadFailureStatus(prcTask.get(), statusMessage);
            } else {
                V4LogContext logContext = V4LogContext.builder().stepId(step.get().getId()).stepType(UPLOAD_STEP_TYPE.name()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
                this.v4Logger.logWarn(log, logContext, "No PRC task present for step");
            }
        }
    }

    private void sendSpaceUploadCancelledStatusToPrcIfV4Task(Optional<Step> step, Optional<PrcTask> prcTask, String statusMessage) {
        if (step.isPresent() && step.get().getPlan().getMigrationProtocol().equals((Object)MigrationProtocol.V4)) {
            if (prcTask.isPresent()) {
                this.progressTracker.sendV4SpaceUploadCancelledStatus(prcTask.get(), statusMessage);
            } else {
                V4LogContext logContext = V4LogContext.builder().stepId(step.get().getId()).stepType(UPLOAD_STEP_TYPE.name()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
                this.v4Logger.logWarn(log, logContext, "No PRC task present for step");
            }
        }
    }

    @Override
    public void runPostStepCompletionTask(String stepId) {
        V4LogContext logContext = V4LogContext.builder().stepId(stepId).stepType(UPLOAD_STEP_TYPE.name()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        try {
            Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
            Path exportFilePath = this.exportDirManager.getExportFilePath(step.getConfig());
            this.v4Logger.logInfo(log, logContext, String.format("Cleaning up the export file path for step is: %s", exportFilePath.toString()));
            this.exportDirManager.cleanupExportFile(exportFilePath);
        }
        catch (Exception e) {
            this.v4Logger.logError(log, logContext, "PostStepCompletion task failed for Space Upload", e);
        }
    }

    private /* synthetic */ Collection lambda$doSpaceUpload$8(Step step, Map additionalAttributes, long freeHeapSizeAtStart, Plan plan) {
        return ImmutableList.of((Object)this.analyticsEventBuilder.buildCompletedStepAnalyticsEvent(step, () -> additionalAttributes), (Object)this.analyticsEventBuilder.buildStepLevelHeapSizeAnalyticsEvent(step, freeHeapSizeAtStart, this.clusterLimits.getClusterConcurrencyLimit(this.getStepType(), plan), this.clusterLimits.getConcurrencyPerNodeLimit(this.getStepType(), plan)));
    }

    private /* synthetic */ void lambda$doSpaceUpload$5(List uploadedFiles, String spaceId, PrcTask task) {
        this.progressTracker.sendV4SpaceUploadCompletionStatus(uploadedFiles, spaceId, task, SUCCESS_STATUS_MESSAGE);
    }

    private /* synthetic */ void lambda$doSpaceUpload$3(List uploadedFiles, String spaceId, PrcTask task) {
        this.progressTracker.sendV4SpaceUploadCompletionStatus(uploadedFiles, spaceId, task, SUCCESS_STATUS_MESSAGE);
    }
}

