/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.globalentities;

import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.TransferStatus;
import com.atlassian.migration.agent.service.impl.StepSubType;
import com.atlassian.migration.agent.service.shadowExecutor.ShadowMigrationExecutor;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.globalentities.GlobalEntitiesExportExecutor;
import com.atlassian.migration.agent.service.stepexecutor.globalentities.GlobalEntitiesUploadExecutor;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.tasks.GlobalEntitiesTransferTask;
import java.util.Collections;
import java.util.Optional;

public class V4GlobalEntitiesUploadExecutor {
    private final GlobalEntitiesExportExecutor globalEntitiesExportExecutor;
    private final GlobalEntitiesUploadExecutor globalEntitiesUploadExecutor;
    private final ProgressTracker progressTracker;
    private final ShadowMigrationExecutor shadowMigrationExecutor;

    public V4GlobalEntitiesUploadExecutor(GlobalEntitiesExportExecutor globalEntitiesExportExecutor, GlobalEntitiesUploadExecutor globalEntitiesUploadExecutor, ProgressTracker progressTracker, ShadowMigrationExecutor shadowMigrationExecutor) {
        this.globalEntitiesExportExecutor = globalEntitiesExportExecutor;
        this.globalEntitiesUploadExecutor = globalEntitiesUploadExecutor;
        this.progressTracker = progressTracker;
        this.shadowMigrationExecutor = shadowMigrationExecutor;
    }

    public StepResult runStepV4(Step step, PrcTask<GlobalEntitiesTransferTask> prcTask) {
        if (this.shadowMigrationExecutor.isShadowMigration(step)) {
            return this.shadowMigrationExecutor.performShadowMigration(step.getId(), prcTask);
        }
        StepResult exportResult = this.globalEntitiesExportExecutor.runStep(step.getId());
        if (Boolean.FALSE.equals(this.sendProgressAndStatusUpdates(step.getId(), prcTask, exportResult, StepSubType.GLOBAL_ENTITIES_EXPORT, 50))) {
            return exportResult;
        }
        this.sendProgressUpdates(50, step.getId(), prcTask, StepSubType.GLOBAL_ENTITIES_UPLOAD);
        StepResult uploadResult = this.globalEntitiesUploadExecutor.runStepV4(step.getId(), exportResult.getResult());
        this.sendProgressAndStatusUpdates(step.getId(), prcTask, uploadResult, StepSubType.GLOBAL_ENTITIES_UPLOAD, 100);
        return uploadResult;
    }

    Boolean sendProgressAndStatusUpdates(String stepId, PrcTask<GlobalEntitiesTransferTask> prcTask, StepResult result, StepSubType stepSubType, int percent) {
        if (!result.isSuccess() && !result.isStopped()) {
            this.progressTracker.sendV4GlobalEntitiesStatus(prcTask, TransferStatus.FAILED, result.getMessage());
            return false;
        }
        if (result.isStopped()) {
            this.progressTracker.sendV4GlobalEntitiesStatus(prcTask, TransferStatus.CANCELLED, result.getMessage());
            return false;
        }
        this.progressTracker.progress(stepId, percent, stepSubType.getDisplayName(), stepSubType.getDetailedStatus(), Collections.emptyMap(), Optional.of(prcTask));
        if (stepSubType.equals(StepSubType.GLOBAL_ENTITIES_UPLOAD)) {
            this.progressTracker.sendV4GlobalEntitiesSuccessStatus(prcTask, result.getResult(), result.getMessage());
        }
        return true;
    }

    void sendProgressUpdates(int percent, String stepId, PrcTask<GlobalEntitiesTransferTask> prcTask, StepSubType stepSubType) {
        this.progressTracker.progress(stepId, percent, stepSubType.getDisplayName(), stepSubType.getDetailedStatus(), Collections.emptyMap(), Optional.of(prcTask));
    }
}

