/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.attachment;

import com.atlassian.migration.agent.entity.Attachment;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.MigrationErrorCode;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.stepexecutor.StepExecutionException;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrationUploadStatus;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrator;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentsUploadTracker;
import com.atlassian.migration.agent.service.util.StopConditionCheckingUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;

class AttachmentsToMigrateConsumer
implements Runnable {
    private static final Logger log = ContextLoggerFactory.getLogger(AttachmentsToMigrateConsumer.class);
    private final BlockingQueue<Attachment> buffer;
    private final CloudSite cloudSite;
    private final AttachmentMigrator attachmentMigrator;
    private final AttachmentsUploadTracker progressTracker;
    private final BooleanSupplier allAttachmentsProduced;
    private final BooleanSupplier forceStop;
    private final String migrationId;
    private final V4Logger v4Logger;

    AttachmentsToMigrateConsumer(CloudSite cloudSite, BlockingQueue<Attachment> buffer, AttachmentMigrator attachmentMigrator, AttachmentsUploadTracker progressTracker, BooleanSupplier allAttachmentsProduced, BooleanSupplier forceStop, String migrationId, V4Logger v4Logger) {
        this.buffer = buffer;
        this.cloudSite = cloudSite;
        this.attachmentMigrator = attachmentMigrator;
        this.progressTracker = progressTracker;
        this.allAttachmentsProduced = allAttachmentsProduced;
        this.forceStop = forceStop;
        this.migrationId = migrationId;
        this.v4Logger = v4Logger;
    }

    @Override
    public void run() {
        block9: {
            V4LogContext logContext = V4LogContext.builder().build();
            logContext.addAdditionalProperties("migrationId", this.migrationId);
            while (true) {
                Attachment attachment;
                if (this.forceStop.getAsBoolean() || StopConditionCheckingUtil.isStopConditionReached()) {
                    this.v4Logger.logInfo(log, logContext, "Stop requested. Will exit...");
                    break block9;
                }
                try {
                    attachment = this.buffer.poll(200L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    this.v4Logger.logError(log, logContext, "Failed to poll attachment from buffer", ex);
                    throw new StepExecutionException(MigrationErrorCode.ATTACHMENT_MIGRATION_INTERRUPTED, StepType.ATTACHMENT_UPLOAD, this.migrationId, "Failed to poll attachment from buffer", ex);
                }
                if (attachment != null) {
                    AttachmentMigrationUploadStatus uploadStatus = this.attachmentMigrator.migrate(attachment, this.cloudSite, this.progressTracker::checkDelayAndUpdateUploadedBytes);
                    switch (uploadStatus) {
                        case UPLOAD_SUCCESS: {
                            this.progressTracker.attachmentUploaded();
                            break;
                        }
                        case UPLOAD_FAILED: {
                            this.progressTracker.attachmentUploadFailed();
                            break;
                        }
                    }
                    logContext.addAdditionalProperties("attachmentId", attachment.getId(), "uploadStatus", uploadStatus.name());
                    this.v4Logger.logDebug(log, logContext, "Attachment upload migration status");
                    continue;
                }
                if (this.allAttachmentsProduced.getAsBoolean()) break;
            }
            this.v4Logger.logInfo(log, logContext, "No more attachments to upload. Will exit...");
        }
    }
}

