/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor;

import java.util.Map;
import javax.annotation.Nullable;
import lombok.Generated;

public class StepResult {
    private final boolean isSuccess;
    private final boolean isStopped;
    private final String message;
    private final String result;
    private final Throwable e;
    private final Map<String, Object> resultProperties;

    private StepResult(boolean isSuccess, boolean isStopped, String message, String result, Throwable e, @Nullable Map<String, Object> resultProperties) {
        this.isSuccess = isSuccess;
        this.isStopped = isStopped;
        this.message = message;
        this.result = result;
        this.e = e;
        this.resultProperties = resultProperties;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public String getMessage() {
        return this.message;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public String getResult() {
        return this.result;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public Throwable getException() {
        return this.e;
    }

    public static StepResult failed(String message) {
        return new StepResult(false, false, message, null, null, null);
    }

    public static StepResult failed(String message, Throwable e) {
        return new StepResult(false, false, message, null, e, null);
    }

    public static StepResult stopped() {
        return new StepResult(false, true, null, null, null, null);
    }

    public static StepResult succeeded(String message) {
        return new StepResult(true, false, message, null, null, null);
    }

    public static StepResult succeeded(String message, String result) {
        return new StepResult(true, false, message, result, null, null);
    }

    public static StepResult succeeded(String message, String result, Map<String, Object> resultProperties) {
        return new StepResult(true, false, message, result, null, resultProperties);
    }

    @Nullable
    @jakarta.annotation.Nullable
    public Map<String, Object> getResultProperties() {
        return this.resultProperties;
    }

    @Generated
    public String toString() {
        return "StepResult(isSuccess=" + this.isSuccess() + ", isStopped=" + this.isStopped() + ", message=" + this.getMessage() + ", result=" + this.getResult() + ", e=" + this.e + ", resultProperties=" + this.getResultProperties() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StepResult)) {
            return false;
        }
        StepResult other = (StepResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.isStopped() != other.isStopped()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        Throwable this$e = this.e;
        Throwable other$e = other.e;
        if (this$e == null ? other$e != null : !this$e.equals(other$e)) {
            return false;
        }
        Map<String, Object> this$resultProperties = this.getResultProperties();
        Map<String, Object> other$resultProperties = other.getResultProperties();
        return !(this$resultProperties == null ? other$resultProperties != null : !((Object)this$resultProperties).equals(other$resultProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StepResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + (this.isStopped() ? 79 : 97);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        Throwable $e = this.e;
        result = result * 59 + ($e == null ? 43 : $e.hashCode());
        Map<String, Object> $resultProperties = this.getResultProperties();
        result = result * 59 + ($resultProperties == null ? 43 : ((Object)$resultProperties).hashCode());
        return result;
    }
}

