/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.log;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.migration.agent.entity.AbstractSpaceTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.TaskType;
import com.atlassian.migration.agent.mapi.MapiArtifactService;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.catalogue.MigrationCatalogueStorageService;
import com.atlassian.migration.agent.service.catalogue.model.MigrationCatalogueStorageFile;
import com.atlassian.migration.agent.service.catalogue.model.TransferStatusResponse;
import com.atlassian.migration.agent.service.event.UploadMigLogsToMCSEvent;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogDirManager;
import com.atlassian.migration.agent.service.log.MigrationLogException;
import com.google.gson.JsonObject;
import jakarta.annotation.Nullable;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class MigrationLogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationLogService.class);
    private static final String SAVE_FORMATTED_LOG_ACTION = "saveFormattedLog";
    private static final String SAVE_FORMATTED_JSON_LOG_ACTION = "saveFormattedJsonLog";
    private static final String FORMAT_MIGRATION_LOG_MESSAGE_ACTION = "formatMigrationLogMessage";
    private static final String UPLOAD_LOG_ZIP_TO_MCS_ACTION = "uploadedLogZipToMcs";
    private static final String UPLOAD_TO_MCS_ACTION = "uploadedFileToMcs";
    private static final String FILE_PREFIX = "migration-log";
    private final MigrationLogDirManager migrationLogDirManager;
    private final MigrationCatalogueStorageService migrationCatalogueStorageService;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final EventPublisher eventPublisher;
    private final MapiArtifactService mapiArtifactService;

    public MigrationLogService(MigrationLogDirManager migrationLogDirManager, MigrationCatalogueStorageService migrationCatalogueStorageService, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, EventPublisher eventPublisher, MapiArtifactService mapiArtifactService) {
        this(migrationLogDirManager, migrationCatalogueStorageService, Instant::now, analyticsEventService, analyticsEventBuilder, eventPublisher, mapiArtifactService);
    }

    @VisibleForTesting
    public MigrationLogService(MigrationLogDirManager migrationLogDirManager, MigrationCatalogueStorageService migrationCatalogueStorageService, Supplier<Instant> instantSupplier, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, EventPublisher eventPublisher, MapiArtifactService mapiArtifactService) {
        this.migrationLogDirManager = migrationLogDirManager;
        this.migrationCatalogueStorageService = migrationCatalogueStorageService;
        this.instantSupplier = instantSupplier;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.eventPublisher = eventPublisher;
        this.mapiArtifactService = mapiArtifactService;
    }

    @PostConstruct
    @jakarta.annotation.PostConstruct
    public void initialise() {
        this.eventPublisher.register((Object)this);
    }

    @javax.annotation.PreDestroy
    @PreDestroy
    public void preDestroy() {
        this.eventPublisher.unregister((Object)this);
    }

    public void saveToLogFile(Step step, String reason, @javax.annotation.Nullable @Nullable Throwable exception) {
        this.saveToLogFile(step, reason, exception, LogFormat.TEXT);
        this.saveToLogFile(step, reason, exception, LogFormat.JSON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToLogFile(TransferStatusResponse response, String reason, String migrationId) {
        if (!StringUtils.isEmpty((String)migrationId)) {
            boolean success = false;
            Optional<String> errorReason = Optional.empty();
            long startTime = this.instantSupplier.get().toEpochMilli();
            try {
                String errorLogMessage = this.logMessageFormat(response, reason, migrationId);
                this.migrationLogDirManager.saveErrorLogsToFile(migrationId, errorLogMessage);
                success = true;
            }
            catch (Exception e) {
                log.error("Failed to save migration error logs to file for migrationId: " + migrationId, (Throwable)e);
                errorReason = Optional.ofNullable(e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
            }
            finally {
                long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
                EventDto timerEvent = this.analyticsEventBuilder.buildMigrationLogTimerEvent(success, timeTaken, SAVE_FORMATTED_LOG_ACTION, migrationId, errorReason);
                this.analyticsEventService.saveAnalyticsEventAsync(() -> timerEvent);
            }
        } else {
            log.info("MigrationId missing for transferId {} with operation key {}. Skipping saving log to the file...!!", (Object)response.getTransferId(), (Object)response.getOperationKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToLogFile(Step step, String reason, @javax.annotation.Nullable @Nullable Throwable exception, LogFormat logFormat) {
        String migrationId = step.getPlan().getMigrationId();
        if (!StringUtils.isEmpty((String)migrationId)) {
            log.info("Saving log with format {} for migrationId {}", (Object)logFormat, (Object)migrationId);
            boolean success = false;
            Optional<String> errorReason = Optional.empty();
            long startTime = this.instantSupplier.get().toEpochMilli();
            try {
                switch (logFormat.ordinal()) {
                    case 1: {
                        JsonObject json = this.createLogJsonObject(step, reason, exception);
                        this.migrationLogDirManager.saveErrorJsonToFile(migrationId, json);
                        break;
                    }
                    case 0: {
                        String message = this.logMessageFormat(step, reason, exception);
                        this.migrationLogDirManager.saveErrorLogsToFile(migrationId, message);
                        break;
                    }
                    default: {
                        log.error("Incorrect log format: {}, specified for migrationId: {}", (Object)logFormat, (Object)migrationId);
                    }
                }
                success = true;
            }
            catch (Exception e) {
                log.error("Failed to save migration error logs to file for migrationId: " + migrationId, (Throwable)e);
                errorReason = Optional.ofNullable(e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
            }
            finally {
                long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
                EventDto timerEvent = this.analyticsEventBuilder.buildMigrationLogTimerEvent(success, timeTaken, logFormat.getAction(), migrationId, errorReason);
                this.analyticsEventService.saveAnalyticsEventAsync(() -> timerEvent);
            }
        } else {
            log.info("MigrationId missing. Skipping saving log to the file...!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadMigrationErrorLogZipToMCS(String planId, String cloudId, @javax.annotation.Nullable @Nullable String migrationId) {
        if (!StringUtils.isEmpty((String)migrationId) && this.errorLogFileExists(migrationId)) {
            boolean success = false;
            long startTime = this.instantSupplier.get().toEpochMilli();
            Optional<String> errorReason = Optional.empty();
            Optional<String> fileName = Optional.ofNullable(this.migrationLogDirManager.getMigrationErrorLogZipFile(migrationId).getFileName().toString());
            try {
                this.migrationLogDirManager.zipMigrationErrorLogFile(migrationId);
                MigrationCatalogueStorageFile migrationCatalogueStorageFile = this.uploadErrorLogFilesToMCS(cloudId, migrationId);
                success = true;
                this.updateArtifactsToMapi(planId, cloudId, migrationId, migrationCatalogueStorageFile);
            }
            catch (Exception e) {
                log.error("Error while zipping log file or uploading zip to MCS for migrationId: " + migrationId, (Throwable)e);
                try (StringWriter sw = new StringWriter();
                     PrintWriter pw = new PrintWriter(sw);){
                    e.printStackTrace(pw);
                    errorReason = Optional.of(sw.toString());
                }
                catch (Exception innerException) {
                    log.error("Error when reading exception stack trace", (Throwable)innerException);
                }
            }
            finally {
                long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
                EventDto timerEvent = this.analyticsEventBuilder.buildMigrationLogTimerEvent(success, timeTaken, UPLOAD_LOG_ZIP_TO_MCS_ACTION, migrationId, cloudId, errorReason, fileName);
                this.analyticsEventService.saveAnalyticsEventAsync(() -> timerEvent);
            }
        } else {
            log.info("Either MigrationId is missing or log file is not present. Skipping uploading of zip file...!!");
        }
    }

    private void updateArtifactsToMapi(String planId, String cloudId, @NotNull String migrationId, MigrationCatalogueStorageFile migrationCatalogueStorageFile) {
        try {
            if (migrationCatalogueStorageFile != null) {
                this.mapiArtifactService.updateArtifactsToMapi(planId, migrationId, cloudId, migrationCatalogueStorageFile.getName(), migrationCatalogueStorageFile.getFileId());
            } else {
                log.error("Failed to upload migration error log zip file for migrationId: " + migrationId);
            }
        }
        catch (Exception e) {
            log.error("Error while updating artifacts to Mapi for planId: " + planId, (Throwable)e);
        }
    }

    private MigrationCatalogueStorageFile uploadErrorLogFilesToMCS(String cloudId, String migrationId) {
        Path migrationErrorLogZipFile = this.migrationLogDirManager.getMigrationErrorLogZipFile(migrationId);
        return this.uploadFilesToMCS(cloudId, migrationId, migrationErrorLogZipFile, () -> this.migrationLogDirManager.cleanupMigrationErrorLogZipFile(migrationId));
    }

    @EventListener
    public void handleClusteredEvent(ClusterEventWrapper clusterEventWrapper) {
        try {
            Method method2 = clusterEventWrapper.getClass().getMethod("getEvent", new Class[0]);
            Object wrappedEvent = method2.invoke((Object)clusterEventWrapper, new Object[0]);
            if (wrappedEvent instanceof UploadMigLogsToMCSEvent) {
                this.handleUploadClusteredMigrationLogFiles((UploadMigLogsToMCSEvent)((Object)wrappedEvent));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to handle ClusteredEvent {}", (Object)clusterEventWrapper, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void handleUploadClusteredMigrationLogFiles(UploadMigLogsToMCSEvent event) {
        log.info("Handling UploadMigLogsToMCSEvent for migrationId: {}", (Object)event.getMigrationId());
        String planId = event.getPlanId();
        String migrationId = event.getMigrationId();
        String cloudId = event.getCloudId();
        boolean success = false;
        long startTime = this.instantSupplier.get().toEpochMilli();
        Optional<Object> reason = Optional.empty();
        Optional<String> fileName = Optional.ofNullable(this.migrationLogDirManager.getMigrationLogZipFile(migrationId).getFileName().toString());
        try {
            Optional<Path> migrationLogZipFile = this.migrationLogDirManager.zipMigrationLogFiles(migrationId, planId);
            if (migrationLogZipFile.isPresent()) {
                this.uploadFilesToMCS(event.getCloudId(), migrationId, migrationLogZipFile.get(), () -> this.migrationLogDirManager.cleanupMigrationLogZipFile(migrationId));
                success = true;
            } else {
                reason = Optional.ofNullable("Migration zip files are not present. Skipping uploading of zip file...!!");
                log.info((String)reason.get());
            }
        }
        catch (Exception e) {
            log.error("Error while zipping log file or handling UploadMigLogsToMCSEvent {} ", (Object)event, (Object)e);
            reason = Optional.ofNullable(e.getMessage());
        }
        finally {
            long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
            EventDto timerEvent = this.analyticsEventBuilder.buildMigrationLogTimerEvent(success, timeTaken, UPLOAD_LOG_ZIP_TO_MCS_ACTION, migrationId, cloudId, reason, fileName);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> timerEvent);
        }
    }

    private MigrationCatalogueStorageFile uploadFilesToMCS(String cloudId, String migrationId, Path migrationLogZipFile, Runnable cleanupMigration) {
        boolean success = false;
        long startTime = this.instantSupplier.get().toEpochMilli();
        Optional<Object> reason = Optional.empty();
        Optional<String> fileName = Optional.ofNullable(migrationLogZipFile.getFileName().toString());
        try {
            if (migrationLogZipFile.toFile().exists()) {
                MigrationCatalogueStorageFile uploadedLogFile = this.migrationCatalogueStorageService.uploadFileToMCSWithPrefix(cloudId, migrationId, migrationLogZipFile, FILE_PREFIX);
                log.info("File uploaded to MCS fileId: {}, name: {}, size: {}", new Object[]{uploadedLogFile.getFileId(), uploadedLogFile.getName(), uploadedLogFile.getSize()});
                success = true;
                MigrationCatalogueStorageFile migrationCatalogueStorageFile = uploadedLogFile;
                return migrationCatalogueStorageFile;
            }
            reason = Optional.ofNullable("Migration log zip files are not present. Skipping uploading of zip file...!!");
            log.info((String)reason.get());
        }
        catch (Exception e) {
            reason = Optional.ofNullable(e.getMessage());
            throw new MigrationLogException(e.getMessage(), e);
        }
        finally {
            cleanupMigration.run();
            long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
            EventDto timerEvent = this.analyticsEventBuilder.buildMigrationLogTimerEvent(success, timeTaken, UPLOAD_TO_MCS_ACTION, migrationId, cloudId, reason, fileName);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> timerEvent);
        }
        return null;
    }

    private JsonObject createLogJsonObject(Step step, String reason, @javax.annotation.Nullable @Nullable Throwable exception) {
        JsonObject logObject = new JsonObject();
        logObject.addProperty("timestamp", this.instantSupplier.get().toString());
        logObject.addProperty("stepType", step.getType());
        logObject.addProperty("taskName", step.getTask().getName());
        logObject.addProperty("reason", reason);
        TaskType taskType = step.getTask().getType();
        logObject.addProperty("taskType", taskType.toString());
        if (taskType == TaskType.SPACE || taskType == TaskType.ATTACHMENTS) {
            AbstractSpaceTask spaceTask = (AbstractSpaceTask)step.getTask();
            logObject.addProperty("entityType", "space");
            logObject.addProperty("entityKey", spaceTask.getSpaceKey());
        }
        if (exception != null) {
            logObject.addProperty("message", exception.getMessage());
            logObject.addProperty("stacktrace", ExceptionUtils.getStackTrace((Throwable)exception));
        }
        return logObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String logMessageFormat(Step step, String reason, @javax.annotation.Nullable @Nullable Throwable exception) {
        boolean success = false;
        long startTime = this.instantSupplier.get().toEpochMilli();
        try {
            String errorMessage = String.format("%s ERROR Step failed, taskName: %s | stepType: %s | message: %s", this.instantSupplier.get().toString(), step.getTask().getName(), StepType.valueOf(step.getType()), reason);
            if (exception != null) {
                String exceptionDetails = String.format("[Exception Details]: %s | %s", exception.getMessage(), ExceptionUtils.getStackTrace((Throwable)exception));
                errorMessage = errorMessage + System.lineSeparator() + exceptionDetails;
            }
            errorMessage = errorMessage + System.lineSeparator();
            success = true;
            String string = errorMessage;
            return string;
        }
        finally {
            long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
            EventDto timerEvent = this.analyticsEventBuilder.buildMigrationLogTimerEvent(success, timeTaken, FORMAT_MIGRATION_LOG_MESSAGE_ACTION, step.getPlan().getMigrationId());
            this.analyticsEventService.saveAnalyticsEventAsync(() -> timerEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String logMessageFormat(TransferStatusResponse response, String reason, String migrationId) {
        boolean success = false;
        long startTime = this.instantSupplier.get().toEpochMilli();
        try {
            String errorMessage = String.format("%s ERROR Step failed, taskName: %s | migrationId: %s | message: %s", this.instantSupplier.get().toString(), response.getOperationKey(), migrationId, reason);
            errorMessage = errorMessage + System.lineSeparator();
            success = true;
            String string = errorMessage;
            return string;
        }
        finally {
            long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
            EventDto timerEvent = this.analyticsEventBuilder.buildMigrationLogTimerEvent(success, timeTaken, FORMAT_MIGRATION_LOG_MESSAGE_ACTION, migrationId);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> timerEvent);
        }
    }

    private boolean errorLogFileExists(String migrationId) {
        File migrationLogFile = this.migrationLogDirManager.getMigrationErrorLogFile(migrationId).toFile();
        return migrationLogFile.exists();
    }

    public void uploadMigrationLogsZipFromClustersToMCS(String cloudId, String migrationId, String planId) {
        if (!StringUtils.isEmpty((String)migrationId)) {
            this.migrationLogDirManager.uploadClusteredMigrationLogFiles(cloudId, migrationId, planId);
        } else {
            log.info("MigrationId is missing. Skipping uploading of Migration log zip file...!!");
        }
    }

    private static enum LogFormat {
        TEXT("saveFormattedLog"),
        JSON("saveFormattedJsonLog");

        private final String action;

        private LogFormat(String action) {
            this.action = action;
        }

        @Generated
        public String getAction() {
            return this.action;
        }
    }
}

