/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.HttpServiceException;
import com.atlassian.migration.agent.okhttp.IOHttpException;
import com.atlassian.migration.agent.okhttp.MediaTypes;
import com.atlassian.migration.agent.okhttp.OKHttpProxyBuilder;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.service.BatchMigrationAppAggregatorResponse;
import com.atlassian.migration.agent.service.MigrationAppAggregatorResponse;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.atlassian.migration.app.MigrationAppAggregatorClient;
import com.atlassian.migration.app.dto.check.DisabledCheck;
import com.atlassian.sal.api.license.BaseLicenseDetails;
import com.atlassian.sal.api.license.LicenseHandler;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

@ParametersAreNonnullByDefault
public class MigrationAppAggregatorService
implements MigrationAppAggregatorClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationAppAggregatorService.class);
    private static final String MAA_CACHE_NAME = "com.atlassian.migration.agent.migrationMarketplaceAppsCacheV2";
    private static final String MAA_CACHE_NAME_OLD = "com.atlassian.migration.agent.migrationMarketplaceAppsCache";
    private static final String APP_LIST_CACHE_NAME = "com.atlassian.migration.agent.appAssessmentlistCache";
    private static final String APP_ASSESSMENT_BLACKLIST_KEY = "appAssessmentBlacklistKey";
    private static final String GET_BLACKLIST_URL = "/resources/blacklist";
    private static final String APP_ASSESSMENT_RELIABLE_LIST_KEY = "appAssessmentReliableListKey";
    private static final String GET_RELIABLE_LIST_URL = "/resources/reliablelist";
    private static final String GET_DISABLED_APP_VENDOR_CHECK_SPEC_URL = "aggregator/app/checks/disabled";
    private static final String GET_BATCH_AGGREGATED_APP_DATA_URL = "batch";
    private static final int BATCH_APP_DATA_CHUNK_SIZE = 50;
    private final HttpService httpService;
    private final MigrationAgentConfiguration configuration;
    private final LicenseHandler licenseHandler;
    private final Cache<Pair<Hosting, String>, MigrationAppAggregatorResponse> maaCache;
    private final Cache<String, Set<String>> appAggregatorListCache;
    private static final int NOT_FOUND = 404;

    public MigrationAppAggregatorService(MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor, CacheManager cacheManager, LicenseHandler licenseHandler, OKHttpProxyBuilder okHttpProxyBuilder) {
        this(new HttpService(() -> MigrationAppAggregatorService.buildHttpClient(userAgentInterceptor, okHttpProxyBuilder)), configuration, cacheManager, licenseHandler);
    }

    @VisibleForTesting
    MigrationAppAggregatorService(HttpService httpService, MigrationAgentConfiguration configuration, CacheManager cacheManager, LicenseHandler licenseHandler) {
        Cache oldMaaCache = cacheManager.getCache(MAA_CACHE_NAME_OLD, this::getAggregatedAppData, new CacheSettingsBuilder().local().expireAfterWrite(55L, TimeUnit.MINUTES).build());
        this.maaCache = cacheManager.getCache(MAA_CACHE_NAME, null, new CacheSettingsBuilder().local().expireAfterWrite(55L, TimeUnit.MINUTES).build());
        this.appAggregatorListCache = cacheManager.getCache(APP_LIST_CACHE_NAME, (CacheLoader)new AppListCacheLoader(), new CacheSettingsBuilder().local().expireAfterWrite(1L, TimeUnit.DAYS).build());
        this.httpService = httpService;
        this.configuration = configuration;
        this.licenseHandler = licenseHandler;
        oldMaaCache.removeAll();
        this.maaCache.removeAll();
        this.appAggregatorListCache.removeAll();
    }

    public MigrationAppAggregatorResponse getCachedServerAppData(String pluginKey) {
        boolean isDataCenter = this.licenseHandler.getAllProductLicenses().stream().anyMatch(BaseLicenseDetails::isDataCenter);
        return this.getCachedOrRemote((Pair<Hosting, String>)Pair.pair((Object)((Object)(isDataCenter ? Hosting.datacenter : Hosting.server)), (Object)pluginKey));
    }

    public List<MigrationAppAggregatorResponse> getBatchCachedServerAppData(Set<String> pluginKeys) {
        boolean isDataCenter = this.licenseHandler.getAllProductLicenses().stream().anyMatch(BaseLicenseDetails::isDataCenter);
        return this.getBatchCachedOrRemote(pluginKeys, isDataCenter ? Hosting.datacenter : Hosting.server);
    }

    public MigrationAppAggregatorResponse getCachedCloudAppData(String pluginKey) {
        return this.getCachedOrRemote((Pair<Hosting, String>)Pair.pair((Object)((Object)Hosting.cloud), (Object)pluginKey));
    }

    public boolean isBlacklisted(String pluginKey) {
        this.validateAndReloadApplist(APP_ASSESSMENT_BLACKLIST_KEY);
        return ((Set)this.appAggregatorListCache.get((Object)APP_ASSESSMENT_BLACKLIST_KEY)).contains(pluginKey);
    }

    public boolean isAppReliable(String pluginKey) {
        this.validateAndReloadApplist(APP_ASSESSMENT_RELIABLE_LIST_KEY);
        return ((Set)this.appAggregatorListCache.get((Object)APP_ASSESSMENT_RELIABLE_LIST_KEY)).contains(pluginKey);
    }

    @Override
    public Set<DisabledCheck> getDisabledAppVendorChecks(Set<String> serverAppKeys) {
        try {
            Request request = new Request.Builder().addHeader("Accept", "application/json").url(this.getUriBuilder().path("/aggregator/app/checks/disabled").toUriString()).post(RequestBody.create((String)Jsons.valueAsString(serverAppKeys), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
            return this.callJsonWithRetries(request, new TypeReference<Set<DisabledCheck>>(){});
        }
        catch (HttpServiceException e) {
            log.warn("Failed to talk to app-aggregator. Returning default values. Error code: {}. Returning emptySet", (Object)e.getStatusCode());
            return Collections.emptySet();
        }
    }

    private MigrationAppAggregatorResponse getCachedOrRemote(Pair<Hosting, String> cacheKey) {
        log.info("Fetching app from cache or remote {}", cacheKey.right());
        MigrationAppAggregatorResponse cached = (MigrationAppAggregatorResponse)this.maaCache.get(cacheKey, () -> this.getAggregatedAppData(cacheKey));
        if (this.isFailedResponse(cached)) {
            this.maaCache.remove(cacheKey);
        }
        return cached;
    }

    private List<MigrationAppAggregatorResponse> getBatchCachedOrRemote(Set<String> pluginKeys, Hosting hosting) {
        log.info("Fetching batch app from cache or remote {}", (Object)hosting);
        List cachedResponses = pluginKeys.stream().map(pluginKey -> (MigrationAppAggregatorResponse)this.maaCache.get((Object)Pair.pair((Object)((Object)hosting), (Object)pluginKey))).filter(Objects::nonNull).collect(Collectors.toList());
        Set<String> remainingPluginKeys = pluginKeys.stream().filter(pluginKey -> cachedResponses.stream().noneMatch(response -> Objects.equals(response.getKey(), pluginKey))).collect(Collectors.toSet());
        log.info("Found {} pluginKeys in cache fetching {} pluginKeys remote", (Object)cachedResponses.size(), (Object)remainingPluginKeys.size());
        ArrayList<MigrationAppAggregatorResponse> remoteResponses = new ArrayList<MigrationAppAggregatorResponse>();
        for (Set<String> chunk : this.chunkPluginKeys(remainingPluginKeys)) {
            remoteResponses.addAll(this.getBatchAggregatedAppDataAndCache(chunk, hosting));
        }
        return Stream.concat(cachedResponses.stream(), remoteResponses.stream()).collect(Collectors.toList());
    }

    private List<Set<String>> chunkPluginKeys(Set<String> pluginKeys) {
        ArrayList<Set<String>> chunks = new ArrayList<Set<String>>();
        for (int i = 0; i < pluginKeys.size(); i += 50) {
            Set chunk = pluginKeys.stream().skip(i).limit(50L).collect(Collectors.toSet());
            chunks.add(chunk);
        }
        return chunks;
    }

    private boolean isSuccessResponse(MigrationAppAggregatorResponse response) {
        return response.getAggregatorHttpErrorCode() == null || response.getErrorResponseHttpStatusCode() < 400 || response.getAggregatorHttpErrorCode() == 404;
    }

    private boolean isFailedResponse(MigrationAppAggregatorResponse cached) {
        return cached.getAggregatorHttpErrorCode() != null && cached.getAggregatorHttpErrorCode() >= 500;
    }

    @VisibleForTesting
    String getURIForList(String key) {
        if (!APP_ASSESSMENT_BLACKLIST_KEY.equals(key) && !APP_ASSESSMENT_RELIABLE_LIST_KEY.equals(key)) {
            throw new IllegalArgumentException("Invalid key used with App list cache : " + key + ". Only appAssessmentReliableListKey or appAssessmentBlacklistKey is allowed.");
        }
        if (APP_ASSESSMENT_BLACKLIST_KEY.equals(key)) {
            return GET_BLACKLIST_URL;
        }
        return GET_RELIABLE_LIST_URL;
    }

    @VisibleForTesting
    void validateAndReloadApplist(String key) {
        Set list = (Set)this.appAggregatorListCache.get((Object)key);
        if (list.isEmpty()) {
            this.appAggregatorListCache.put((Object)key, this.getAppAssessmentListFromAggregator(key));
        }
    }

    @javax.annotation.Nonnull
    @Nonnull
    private MigrationAppAggregatorResponse getAggregatedAppData(Pair<Hosting, String> pluginKey) {
        log.info("Fetching app data from app-aggregator for pluginKey: {}", pluginKey.right());
        try {
            Request request = new Request.Builder().addHeader("Accept", "application/json").url(this.getUriBuilder().path("/" + (String)pluginKey.right()).query("application=confluence").query("hosting=" + pluginKey.left()).toUriString()).get().build();
            return this.callJsonWithRetries(request, new TypeReference<MigrationAppAggregatorResponse>(){});
        }
        catch (HttpServiceException e) {
            log.warn("Failed to talk to app-aggregator for pluginKey: {}. Returning default values. Error code: {}", pluginKey.right(), (Object)e.getStatusCode());
            return MigrationAppAggregatorResponse.empty(e.getStatusCode());
        }
    }

    @javax.annotation.Nonnull
    @Nonnull
    private List<MigrationAppAggregatorResponse> getBatchAggregatedAppDataAndCache(Set<String> pluginKeys, Hosting hosting) {
        log.info("Fetching batch app data from app-aggregator for pluginKeys: {}", pluginKeys);
        try {
            Request request = new Request.Builder().addHeader("Accept", "application/json").url(this.getUriBuilder().path("/batch").query("application=confluence").query("hosting=" + (Object)((Object)hosting)).toUriString()).post(RequestBody.create((String)Jsons.valueAsString(pluginKeys), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
            log.info("Fetching batch app data from remote {}", (Object)request.url());
            BatchMigrationAppAggregatorResponse response = this.callJsonWithRetries(request, new TypeReference<BatchMigrationAppAggregatorResponse>(){});
            List<MigrationAppAggregatorResponse> result = response.getApps().stream().map(app -> {
                if (app.getErrorResponseHttpStatusCode() < 400) {
                    return app;
                }
                return MigrationAppAggregatorResponse.empty(app.getKey(), app.getErrorResponseHttpStatusCode());
            }).collect(Collectors.toList());
            result.stream().filter(this::isSuccessResponse).forEach(app -> this.maaCache.put((Object)Pair.pair((Object)((Object)hosting), (Object)app.getKey()), app));
            return result;
        }
        catch (HttpServiceException e) {
            log.warn("Failed to batch app data for pluginKeys: {}. Returning default values. Error code: {}", pluginKeys, (Object)e.getStatusCode());
            return pluginKeys.stream().map(pluginKey -> MigrationAppAggregatorResponse.empty(pluginKey, e.getStatusCode())).collect(Collectors.toList());
        }
    }

    private Set<String> getAppAssessmentListFromAggregator(String key) {
        String url = this.getURIForList(key);
        try {
            Request request = new Request.Builder().addHeader("Accept", "application/json").url(this.getUriBuilder().path(url).toUriString()).get().build();
            return this.callJsonWithRetries(request, new TypeReference<HashSet<String>>(){});
        }
        catch (HttpServiceException e) {
            log.warn("Failed to get app assessment list from app-aggregator. Returning empty blacklist. Error code: {}", (Object)e.getStatusCode());
            return new HashSet<String>();
        }
        catch (IOHttpException e) {
            log.warn("Failed to get app assessment list from app-aggregator. Returning empty blacklist. Error: {}", (Object)e.getMessage());
            return new HashSet<String>();
        }
    }

    private <T> T callJsonWithRetries(Request request, TypeReference<T> bodyType) {
        RetryPolicy retryPolicy = RetryPolicyBuilder.maaClientPolicy().build();
        return (T)Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.httpService.callJson(request, bodyType));
    }

    private UriComponentsBuilder getUriBuilder() {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getMigrationAppAggregatorUrl());
    }

    private static OkHttpClient buildHttpClient(UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder) {
        return okHttpProxyBuilder.getProxyBuilder().connectTimeout(5L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout(20L, TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor).build();
    }

    private class AppListCacheLoader
    implements CacheLoader<String, Set<String>> {
        private AppListCacheLoader() {
        }

        @javax.annotation.Nonnull
        @Nonnull
        public Set<String> load(@javax.annotation.Nonnull @Nonnull String key) {
            return MigrationAppAggregatorService.this.getAppAssessmentListFromAggregator(key);
        }
    }

    public static enum Hosting {
        server,
        datacenter,
        cloud;

    }
}

