/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.newexport.processor.ColumnTransformer;
import com.atlassian.migration.agent.newexport.processor.P2ToForgeMacroBodyContentTransformerImpl;
import com.atlassian.migration.agent.service.ExportTransformerService;
import com.atlassian.migration.agent.service.PlanService;
import com.atlassian.migration.agent.service.catalogue.PlatformService;
import com.atlassian.migration.app.DefaultRegistrar;
import com.atlassian.migration.app.dto.AppContainerDetails;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTransformerServiceImpl
implements ExportTransformerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportTransformerServiceImpl.class);
    private final PlanService planService;
    private final DefaultRegistrar defaultRegistrar;
    private final PlatformService platformService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    public static final String DEBUG_PLAN_ID = "debug-plan";

    public ExportTransformerServiceImpl(PlanService planService, PlatformService platformService, DefaultRegistrar defaultRegistrar, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.planService = planService;
        this.platformService = platformService;
        this.defaultRegistrar = defaultRegistrar;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    @Override
    public List<ColumnTransformer> getTransformers(String planId) {
        if (DEBUG_PLAN_ID.equals(planId)) {
            log.info("Debug plan id detected, returning no app transformers");
            return Collections.emptyList();
        }
        PlanDto plan = this.planService.getPlan(planId);
        if (plan == null) {
            log.warn("no plan was able to be retrieved for planId={}", (Object)planId);
            return Collections.emptyList();
        }
        ArrayList<ColumnTransformer> transformers = new ArrayList<ColumnTransformer>();
        transformers.addAll(this.getAppTransformers(plan));
        return transformers;
    }

    private List<ColumnTransformer> getAppTransformers(PlanDto plan) {
        Set<AppContainerDetails> appContainers;
        Map<String, String> allMacroMappings;
        if (this.migrationDarkFeaturesManager.isP2toForgeMacroConversionEnabled() && !(allMacroMappings = this.defaultRegistrar.getConfluenceForgeMacroMappings(appContainers = this.platformService.getAppContainers(plan.getCloudSite().getCloudId(), plan.getMigrationId()), plan.getCloudSite().getCloudId())).isEmpty()) {
            return Collections.singletonList(new P2ToForgeMacroBodyContentTransformerImpl(allMacroMappings));
        }
        return Collections.emptyList();
    }
}

