/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.ConcurrencySettingsEnum;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.service.impl.ConcurrencyHelper;
import com.atlassian.migration.agent.service.impl.ConcurrencySettingsCalculator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class ConcurrencySettingsServiceAutomatic {
    private final ConcurrencySettingsCalculator calculator;

    public ConcurrencySettingsServiceAutomatic(ConcurrencyHelper helper, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.calculator = new ConcurrencySettingsCalculator(helper, migrationDarkFeaturesManager);
    }

    public Map<ConcurrencySettingsEnum, Integer> getSettings(Optional<Plan> plan) {
        return this.calculator.redistributePercentages(plan);
    }

    public int getSpaceUsersMigrationExecutorConcurrencyClusterMax() {
        return this.calculator.getSpaceUsersConcurrencyMax();
    }

    public int getSpaceUsersMigrationConcurrencyNodeMax() {
        return this.calculator.getSpaceUsersConcurrencyNodeMax();
    }

    public int getAttachmentMigrationConcurrencyClusterMax(@Nullable Plan plan) {
        return this.calculator.getAttachmentConcurrencyClusterMax(Optional.ofNullable(plan));
    }

    public int getAttachmentMigrationConcurrencyNodeMax(Plan plan) {
        return this.calculator.getAttachmentConcurrencyNodeMax(Optional.ofNullable(plan));
    }

    public Integer getExportConcurrencyNodeMax() {
        return this.calculator.getExportConcurrencyNodeMax();
    }

    public Integer getExportConcurrencyClusterMax() {
        return this.calculator.getExportConcurrencyClusterMax();
    }

    public Integer getUploadConcurrencyClusterMax() {
        return this.calculator.getUploadConcurrencyClusterMax();
    }

    public int getUploadConcurrencyNodeMax() {
        return this.calculator.getUploadConcurrencyNodeMax();
    }

    public int getImportConcurrencyClusterMax() {
        return this.calculator.getImportConcurrencyClusterMax();
    }

    public int getImportConcurrencyNodeMax() {
        return this.calculator.getImportConcurrencyNodeMax();
    }

    public int getAttachmentUploadConcurrency() {
        return this.calculator.getAttachmentUploadConcurrency();
    }

    public boolean isSkipAttachmentUploadEnabled(Optional<Plan> plan) {
        return this.calculator.isSkipAttachmentUploadEnabled(plan);
    }

    public boolean isAttachmentOnlyMigration(Optional<Plan> plan) {
        return this.calculator.isAttachmentOnlyMigration(plan);
    }

    public boolean isV4MigrationProtocolEnabled() {
        return this.calculator.isV4MigrationProtocolEnabled();
    }
}

