/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.ConcurrencySettingsEnum;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.featureflag.StatsigDynamicConfigs;
import com.atlassian.migration.agent.service.impl.ConcurrencyHelper;
import com.atlassian.migration.agent.service.impl.ConcurrencySettingsServiceAutomatic;
import com.atlassian.migration.agent.service.impl.ConcurrencySettingsServiceManual;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class ConcurrencySettingsService {
    private static final Logger LOGGER = ContextLoggerFactory.getLogger(ConcurrencySettingsService.class);
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final ConcurrencySettingsServiceAutomatic automatic;
    private final ConcurrencySettingsServiceManual legacy;
    private final ConcurrencyHelper concurrencyHelper;

    public ConcurrencySettingsService(PluginSettingsFactory pluginSettingsFactory, ClusterManager clusterManager, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.concurrencyHelper = new ConcurrencyHelper(clusterManager);
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.automatic = new ConcurrencySettingsServiceAutomatic(this.concurrencyHelper, migrationDarkFeaturesManager);
        this.legacy = new ConcurrencySettingsServiceManual(() -> ((PluginSettingsFactory)pluginSettingsFactory).createGlobalSettings(), migrationDarkFeaturesManager);
    }

    @VisibleForTesting
    ConcurrencySettingsService(MigrationDarkFeaturesManager migrationDarkFeaturesManager, ConcurrencySettingsServiceAutomatic automatic, ConcurrencySettingsServiceManual legacy, ConcurrencyHelper concurrencyHelper) {
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.automatic = automatic;
        this.legacy = legacy;
        this.concurrencyHelper = concurrencyHelper;
    }

    public Map<String, Object> getConcurrencyParameters(Optional<Plan> plan) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(MigrationDarkFeaturesManager.FeatureFlags.ENABLE_PARALLELISM_AUTO_SETUP.getFlagName(), this.isParallelismAutoSetupEnabled());
        map.put(StatsigDynamicConfigs.ENABLE_V4_MIGRATION_PROTOCOL.getConfigName(), this.automatic.isV4MigrationProtocolEnabled());
        map.put("migration-assistant-attachment-only", this.automatic.isAttachmentOnlyMigration(plan));
        map.put(MigrationDarkFeaturesManager.FeatureFlags.SKIP_ATTACHMENTS_UPLOAD.getFlagName(), this.automatic.isSkipAttachmentUploadEnabled(plan));
        return map;
    }

    public Map<ConcurrencySettingsEnum, Integer> getSettings() {
        return this.getSettings(Optional.empty());
    }

    public Map<ConcurrencySettingsEnum, Integer> getSettings(Optional<Plan> plan) {
        boolean parallelismAutoSetupEnabled = this.isParallelismAutoSetupEnabled();
        Map<ConcurrencySettingsEnum, Integer> map = parallelismAutoSetupEnabled ? this.automatic.getSettings(plan) : this.legacy.getSettings();
        this.info("ThreadsAutoDistribution|getSettings()", parallelismAutoSetupEnabled, map);
        return map;
    }

    public boolean putSettings(Object settingsTypeValue) {
        if (this.isParallelismAutoSetupEnabled()) {
            this.info("ThreadsAutoDistribution|putSettings()", true, "On auto scale mode, nothing more will be done in this method");
            return true;
        }
        return this.legacy.putSettings(settingsTypeValue);
    }

    public int getSpaceUsersMigrationExecutorConcurrencyClusterMax() {
        boolean parallelismAutoSetupEnabled = this.isParallelismAutoSetupEnabled();
        int value = parallelismAutoSetupEnabled ? this.automatic.getSpaceUsersMigrationExecutorConcurrencyClusterMax() : this.legacy.getSpaceUsersMigrationExecutorConcurrencyClusterMax();
        this.info("ThreadsAutoDistribution|getSpaceUsersMigrationExecutorConcurrencyClusterMax()", parallelismAutoSetupEnabled, value);
        return value;
    }

    public int getSpaceUsersMigrationConcurrencyNodeMax() {
        boolean parallelismAutoSetupEnabled = this.isParallelismAutoSetupEnabled();
        int value = parallelismAutoSetupEnabled ? this.automatic.getSpaceUsersMigrationConcurrencyNodeMax() : this.legacy.getSpaceUsersMigrationConcurrencyNodeMax();
        this.info("ThreadsAutoDistribution|getSpaceUsersMigrationConcurrencyNodeMax()", parallelismAutoSetupEnabled, value);
        return value;
    }

    public int getAttachmentMigrationConcurrencyClusterMax(@Nullable Plan plan) {
        boolean parallelismAutoSetupEnabled = this.isParallelismAutoSetupEnabled();
        int value = parallelismAutoSetupEnabled ? this.automatic.getAttachmentMigrationConcurrencyClusterMax(plan) : this.legacy.getAttachmentMigrationConcurrencyClusterMax();
        this.info("ThreadsAutoDistribution|getAttachmentMigrationConcurrencyClusterMax()", parallelismAutoSetupEnabled, value);
        return value;
    }

    public int getAttachmentMigrationConcurrencyNodeMax(Plan plan) {
        boolean parallelismAutoSetupEnabled = this.isParallelismAutoSetupEnabled();
        int value = parallelismAutoSetupEnabled ? this.automatic.getAttachmentMigrationConcurrencyNodeMax(plan) : this.legacy.getAttachmentMigrationConcurrencyNodeMax();
        this.info("ThreadsAutoDistribution|getAttachmentMigrationConcurrencyNodeMax()", parallelismAutoSetupEnabled, value);
        return value;
    }

    public Integer getExportConcurrencyNodeMax() {
        boolean parallelismAutoSetupEnabled = this.isParallelismAutoSetupEnabled();
        int value = parallelismAutoSetupEnabled ? this.automatic.getExportConcurrencyNodeMax() : this.legacy.getExportConcurrencyNodeMax();
        this.info("ThreadsAutoDistribution|getExportConcurrencyNodeMax()", parallelismAutoSetupEnabled, value);
        return value;
    }

    public Integer getExportConcurrencyClusterMax() {
        boolean parallelismAutoSetupEnabled = this.isParallelismAutoSetupEnabled();
        int value = parallelismAutoSetupEnabled ? this.automatic.getExportConcurrencyClusterMax() : this.legacy.getExportConcurrencyClusterMax();
        this.info("ThreadsAutoDistribution|getExportConcurrencyClusterMax()", parallelismAutoSetupEnabled, value);
        return value;
    }

    public Integer getUploadConcurrencyClusterMax() {
        boolean parallelismAutoSetupEnabled = this.isParallelismAutoSetupEnabled();
        int value = parallelismAutoSetupEnabled ? this.automatic.getUploadConcurrencyClusterMax() : this.legacy.getUploadConcurrencyClusterMax();
        this.info("ThreadsAutoDistribution|getUploadConcurrencyClusterMax()", parallelismAutoSetupEnabled, value);
        return value;
    }

    public int getUploadConcurrencyNodeMax() {
        boolean parallelismAutoSetupEnabled = this.isParallelismAutoSetupEnabled();
        int value = parallelismAutoSetupEnabled ? this.automatic.getUploadConcurrencyNodeMax() : this.legacy.getUploadConcurrencyNodeMax();
        this.info("ThreadsAutoDistribution|getUploadConcurrencyNodeMax()", parallelismAutoSetupEnabled, value);
        return value;
    }

    public int getImportConcurrencyClusterMax() {
        boolean parallelismAutoSetupEnabled = this.isParallelismAutoSetupEnabled();
        int value = parallelismAutoSetupEnabled ? this.automatic.getImportConcurrencyClusterMax() : this.legacy.getImportConcurrencyClusterMax();
        this.info("ThreadsAutoDistribution|getImportConcurrencyClusterMax()", parallelismAutoSetupEnabled, value);
        return value;
    }

    public int getImportConcurrencyNodeMax() {
        boolean parallelismAutoSetupEnabled = this.isParallelismAutoSetupEnabled();
        int value = parallelismAutoSetupEnabled ? this.automatic.getImportConcurrencyNodeMax() : this.legacy.getImportConcurrencyNodeMax();
        this.info("ThreadsAutoDistribution|getImportConcurrencyNodeMax()", parallelismAutoSetupEnabled, value);
        return value;
    }

    public int getAttachmentUploadConcurrency() {
        boolean parallelismAutoSetupEnabled = this.isParallelismAutoSetupEnabled();
        int value = parallelismAutoSetupEnabled ? this.automatic.getAttachmentUploadConcurrency() : this.legacy.getAttachmentUploadConcurrency();
        this.info("ThreadsAutoDistribution|getAttachmentUploadConcurrency()", parallelismAutoSetupEnabled, value);
        return value;
    }

    public boolean isParallelismAutoSetupEnabled() {
        return this.migrationDarkFeaturesManager.isParallelismAutoSetupEnabled() && this.concurrencyHelper.isMatchingClusterRequirements();
    }

    private void info(String prefix, boolean parallelismAutoSetupEnabled, Object object) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] isParallelismAutoSetupEnabled? '{}' Value: '{}'", new Object[]{prefix, parallelismAutoSetupEnabled, object});
        }
    }
}

