/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.remote;

import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentConfig;
import com.atlassian.migration.agent.service.guardrails.remote.CloudJobType;
import com.atlassian.migration.agent.service.guardrails.remote.InstanceAssessmentConfigClient;
import com.atlassian.migration.agent.service.guardrails.remote.InstanceAssessmentUploadService;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsightPrcCommandExecutor
implements Runnable,
Consumer<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InsightPrcCommandExecutor.class);
    private final InstanceAssessmentUploadService instanceAssessmentUploadService;
    private final InstanceAssessmentConfigClient instanceAssessmentConfigClient;

    public InsightPrcCommandExecutor(InstanceAssessmentUploadService instanceAssessmentUploadService, InstanceAssessmentConfigClient instanceAssessmentConfigClient) {
        this.instanceAssessmentUploadService = instanceAssessmentUploadService;
        this.instanceAssessmentConfigClient = instanceAssessmentConfigClient;
    }

    @Override
    public void run() {
        this.runAssessments(this.instanceAssessmentConfigClient.getDefaultConfig());
    }

    @Override
    public void accept(@Nullable @jakarta.annotation.Nullable String s) {
        InstanceAssessmentConfig config = InstanceAssessmentConfig.deserialize(s).orElse(this.instanceAssessmentConfigClient.getDefaultConfig());
        this.runAssessments(config);
    }

    private void runAssessments(InstanceAssessmentConfig config) {
        try {
            this.instanceAssessmentUploadService.runAssessments(CloudJobType.ASSESSMENT, config);
        }
        catch (Exception e) {
            log.error("Error while starting instance assessment remotely", (Throwable)e);
            try {
                this.instanceAssessmentUploadService.failInCloud(CloudJobType.ASSESSMENT, e);
            }
            catch (Exception ex) {
                log.error("Error while calling failInCloud", (Throwable)e);
            }
        }
    }
}

