/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.remote;

import com.atlassian.migration.agent.compatibility.WebApplicationExceptionFactory;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.service.guardrails.remote.CloudJobType;
import com.atlassian.migration.agent.service.guardrails.remote.SafeExceptionReport;
import com.atlassian.migration.agent.service.guardrails.remote.SafeExceptionReporter;
import com.atlassian.plugins.cloud.connect.companion.client.CloudContext;
import com.atlassian.plugins.cloud.connect.companion.client.CloudObjectMapper;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequest;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestMethod;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestService;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceLocator;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceNotAvailableException;
import com.atlassian.plugins.cloud.connect.companion.client.CloudResponse;
import com.atlassian.plugins.cloud.connect.companion.client.IncompatibleServiceException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.util.UriComponentsBuilder;

public class CloudAssessmentCommunicationService {
    private static final Logger log = LoggerFactory.getLogger(CloudAssessmentCommunicationService.class);
    private static final String ASSESSMENTS_BASE_PATH = "/l1-assessments";
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final CloudRequestServiceLocator cloudRequestServiceLocator;
    private final ObjectMapper objectMapper;
    private final SafeExceptionReporter safeExceptionReporter;

    public void failInCloud(CloudJobType jobType, Throwable throwable) throws MalformedURLException, CloudRequestServiceNotAvailableException {
        log.info("Sending Assessment failed status for job type: {}", (Object)jobType);
        SafeExceptionReport safeExceptionReport = this.safeExceptionReporter.sanitizeException(throwable);
        CloudResponse<String> cloudResponse = this.sendFailAssessmentRequest(jobType, safeExceptionReport);
        this.validateResponse(cloudResponse, HttpStatus.OK.value());
    }

    public void cancelInCloud(CloudJobType jobType) throws MalformedURLException, CloudRequestServiceNotAvailableException {
        log.info("Sending Assessment cancel status for job type: {}", (Object)jobType);
        CloudResponse<String> cloudResponse = this.sendCancelAssessmentRequest(jobType);
        this.validateResponse(cloudResponse, HttpStatus.OK.value());
    }

    public CloudResponse<String> sendFinishAssessmentRequest(CloudJobType cloudJobType, @javax.annotation.Nullable @Nullable File zipFile) throws MalformedURLException, CloudRequestServiceNotAvailableException {
        URL url = this.buildUrl(ASSESSMENTS_BASE_PATH, cloudJobType);
        CloudRequest.HeaderCollector request = CloudRequest.builder((Object)zipFile).method(CloudRequestMethod.PUT).url(url).cloudContext(CloudContext.defaultContext());
        if (zipFile != null) {
            request.header("Content-Type", "multipart/form-data");
            log.info("Sending finish assessment request with file of size: {}. For cloudJobType: {}", (Object)zipFile.length(), (Object)cloudJobType);
        } else {
            log.info("Sending finish assessment request with empty body. For cloudJobType: {}", (Object)cloudJobType);
        }
        return this.sendRequest(request.build(), String.class);
    }

    private CloudResponse<String> sendFailAssessmentRequest(CloudJobType cloudJobType, SafeExceptionReport safeExceptionReport) throws MalformedURLException, CloudRequestServiceNotAvailableException {
        URL url = this.buildUrl("/l1-assessments/fail", cloudJobType);
        CloudRequest request = CloudRequest.builder((Object)safeExceptionReport).method(CloudRequestMethod.PUT).url(url).cloudContext(CloudContext.defaultContext()).header("Content-Type", "application/json").build();
        return this.sendRequest(request, String.class);
    }

    private CloudResponse<String> sendCancelAssessmentRequest(CloudJobType cloudJobType) throws MalformedURLException, CloudRequestServiceNotAvailableException {
        URL url = this.buildUrl("/l1-assessments/cancel", cloudJobType);
        CloudRequest request = CloudRequest.builder(null).method(CloudRequestMethod.PUT).url(url).cloudContext(CloudContext.defaultContext()).build();
        return this.sendRequest(request, String.class);
    }

    private URL buildUrl(String path, CloudJobType cloudJobType) throws MalformedURLException {
        return UriComponentsBuilder.fromUriString((String)this.migrationAgentConfiguration.getPortfolioAnalyzerServiceUrl()).path(path).queryParam("jobType", new Object[]{cloudJobType.name()}).build().toUri().toURL();
    }

    private <T> CloudResponse<String> sendRequest(CloudRequest<T> request, Class<String> responseType) throws CloudRequestServiceNotAvailableException {
        CloudRequestService cloudRequestService = this.cloudRequestServiceLocator.getCloudRequestService();
        return cloudRequestService.sendRequest(request, responseType, this.createCloudObjectMapper());
    }

    private CloudObjectMapper createCloudObjectMapper() {
        return new CloudObjectMapper(){

            public <T> T readValue(byte[] bytes, Class<T> aClass) throws IOException {
                return (T)CloudAssessmentCommunicationService.this.objectMapper.readValue(bytes, aClass);
            }

            public byte[] writeValueAsBytes(Object object) throws IOException {
                return CloudAssessmentCommunicationService.this.objectMapper.writeValueAsBytes(object);
            }
        };
    }

    public boolean isConnected() {
        try {
            return this.cloudRequestServiceLocator.getCloudLink().isPresent();
        }
        catch (CloudRequestServiceNotAvailableException | IncompatibleServiceException e) {
            return false;
        }
    }

    private void validateResponse(CloudResponse<String> cloudResponse, int expectedStatus) {
        if (cloudResponse.getStatusCode() != expectedStatus) {
            throw WebApplicationExceptionFactory.create((String)cloudResponse.getBody(), cloudResponse.getStatusCode());
        }
    }

    @Generated
    public CloudAssessmentCommunicationService(MigrationAgentConfiguration migrationAgentConfiguration, CloudRequestServiceLocator cloudRequestServiceLocator, ObjectMapper objectMapper, SafeExceptionReporter safeExceptionReporter) {
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.cloudRequestServiceLocator = cloudRequestServiceLocator;
        this.objectMapper = objectMapper;
        this.safeExceptionReporter = safeExceptionReporter;
    }
}

